/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.ExportAuthorization;

public final class ImmutableExportAuthorization
implements ExportAuthorization {
    private final int identifier;
    private final int dcId;

    private ImmutableExportAuthorization(int dcId) {
        this.dcId = dcId;
        this.identifier = ExportAuthorization.super.identifier();
    }

    private ImmutableExportAuthorization(Builder builder) {
        this.dcId = builder.dcId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ExportAuthorization.super.identifier();
    }

    private ImmutableExportAuthorization(int identifier, int dcId) {
        this.identifier = identifier;
        this.dcId = dcId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    public final ImmutableExportAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportAuthorization(value, this.dcId);
    }

    public final ImmutableExportAuthorization withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableExportAuthorization(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportAuthorization && this.equalTo(0, (ImmutableExportAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportAuthorization another) {
        return this.identifier == another.identifier && this.dcId == another.dcId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dcId;
        return h;
    }

    public String toString() {
        return "ExportAuthorization{identifier=" + this.identifier + ", dcId=" + this.dcId + "}";
    }

    public static ImmutableExportAuthorization of(int dcId) {
        return new ImmutableExportAuthorization(dcId);
    }

    public static ImmutableExportAuthorization copyOf(ExportAuthorization instance) {
        if (instance instanceof ImmutableExportAuthorization) {
            return (ImmutableExportAuthorization)instance;
        }
        return ImmutableExportAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DC_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int dcId;

        private Builder() {
        }

        public final Builder from(ExportAuthorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExportAuthorization instance;
            long bits = 0L;
            if (object instanceof ExportAuthorization) {
                instance = (ExportAuthorization)object;
                this.dcId(instance.dcId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExportAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dcId");
            }
            return "Cannot build ExportAuthorization, some of required attributes are not set " + attributes;
        }
    }
}

