/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.ExportLoginToken;

public final class ImmutableExportLoginToken
implements ExportLoginToken {
    private final int identifier;
    private final int apiId;
    private final String apiHash;
    private final List<Long> exceptIds;

    private ImmutableExportLoginToken(int apiId, String apiHash) {
        this.apiId = apiId;
        this.apiHash = Objects.requireNonNull(apiHash, "apiHash");
        this.exceptIds = Collections.emptyList();
        this.identifier = ExportLoginToken.super.identifier();
    }

    private ImmutableExportLoginToken(Builder builder) {
        this.apiId = builder.apiId;
        this.apiHash = builder.apiHash;
        this.exceptIds = ImmutableExportLoginToken.createUnmodifiableList(true, builder.exceptIds);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ExportLoginToken.super.identifier();
    }

    private ImmutableExportLoginToken(int identifier, int apiId, String apiHash, List<Long> exceptIds) {
        this.identifier = identifier;
        this.apiId = apiId;
        this.apiHash = apiHash;
        this.exceptIds = exceptIds;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int apiId() {
        return this.apiId;
    }

    @Override
    public String apiHash() {
        return this.apiHash;
    }

    @Override
    public List<Long> exceptIds() {
        return this.exceptIds;
    }

    public final ImmutableExportLoginToken withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportLoginToken(value, this.apiId, this.apiHash, this.exceptIds);
    }

    public final ImmutableExportLoginToken withApiId(int value) {
        if (this.apiId == value) {
            return this;
        }
        return new ImmutableExportLoginToken(this.identifier, value, this.apiHash, this.exceptIds);
    }

    public final ImmutableExportLoginToken withApiHash(String value) {
        String newValue = Objects.requireNonNull(value, "apiHash");
        if (this.apiHash.equals(newValue)) {
            return this;
        }
        return new ImmutableExportLoginToken(this.identifier, this.apiId, newValue, this.exceptIds);
    }

    public final ImmutableExportLoginToken withExceptIds(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableExportLoginToken.createUnmodifiableList(false, wrappedList);
        return new ImmutableExportLoginToken(this.identifier, this.apiId, this.apiHash, newValue);
    }

    public final ImmutableExportLoginToken withExceptIds(Iterable<Long> elements) {
        if (this.exceptIds == elements) {
            return this;
        }
        List<Long> newValue = ImmutableExportLoginToken.createUnmodifiableList(false, ImmutableExportLoginToken.createSafeList(elements, true, false));
        return new ImmutableExportLoginToken(this.identifier, this.apiId, this.apiHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportLoginToken && this.equalTo(0, (ImmutableExportLoginToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportLoginToken another) {
        return this.identifier == another.identifier && this.apiId == another.apiId && this.apiHash.equals(another.apiHash) && this.exceptIds.equals(another.exceptIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.apiId;
        h += (h << 5) + this.apiHash.hashCode();
        h += (h << 5) + this.exceptIds.hashCode();
        return h;
    }

    public String toString() {
        return "ExportLoginToken{identifier=" + this.identifier + ", apiId=" + this.apiId + ", apiHash=" + this.apiHash + ", exceptIds=" + this.exceptIds + "}";
    }

    public static ImmutableExportLoginToken of(int apiId, String apiHash) {
        return new ImmutableExportLoginToken(apiId, apiHash);
    }

    public static ImmutableExportLoginToken copyOf(ExportLoginToken instance) {
        if (instance instanceof ImmutableExportLoginToken) {
            return (ImmutableExportLoginToken)instance;
        }
        return ImmutableExportLoginToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_API_ID = 1L;
        private static final long INIT_BIT_API_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int apiId;
        private String apiHash;
        private List<Long> exceptIds = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(ExportLoginToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExportLoginToken instance;
            long bits = 0L;
            if (object instanceof ExportLoginToken) {
                instance = (ExportLoginToken)object;
                this.addAllExceptIds(instance.exceptIds());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.apiHash(instance.apiHash());
                this.apiId(instance.apiId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder apiId(int apiId) {
            this.apiId = apiId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder apiHash(String apiHash) {
            this.apiHash = Objects.requireNonNull(apiHash, "apiHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addExceptId(long element) {
            this.exceptIds.add(element);
            return this;
        }

        public final Builder addExceptIds(long ... elements) {
            for (long element : elements) {
                this.exceptIds.add(element);
            }
            return this;
        }

        public final Builder exceptIds(Iterable<Long> elements) {
            this.exceptIds.clear();
            return this.addAllExceptIds(elements);
        }

        public final Builder addAllExceptIds(Iterable<Long> elements) {
            for (Long element : elements) {
                this.exceptIds.add(Objects.requireNonNull(element, "exceptIds element"));
            }
            return this;
        }

        public ImmutableExportLoginToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportLoginToken(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("apiHash");
            }
            return "Cannot build ExportLoginToken, some of required attributes are not set " + attributes;
        }
    }
}

