/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.ImportBotAuthorization;

public final class ImmutableImportBotAuthorization
implements ImportBotAuthorization {
    private final int identifier;
    private final int flags;
    private final int apiId;
    private final String apiHash;
    private final String botAuthToken;

    private ImmutableImportBotAuthorization(int flags, int apiId, String apiHash, String botAuthToken) {
        this.flags = flags;
        this.apiId = apiId;
        this.apiHash = Objects.requireNonNull(apiHash, "apiHash");
        this.botAuthToken = Objects.requireNonNull(botAuthToken, "botAuthToken");
        this.identifier = ImportBotAuthorization.super.identifier();
    }

    private ImmutableImportBotAuthorization(Builder builder) {
        this.flags = builder.flags;
        this.apiId = builder.apiId;
        this.apiHash = builder.apiHash;
        this.botAuthToken = builder.botAuthToken;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ImportBotAuthorization.super.identifier();
    }

    private ImmutableImportBotAuthorization(int identifier, int flags, int apiId, String apiHash, String botAuthToken) {
        this.identifier = identifier;
        this.flags = flags;
        this.apiId = apiId;
        this.apiHash = apiHash;
        this.botAuthToken = botAuthToken;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public int apiId() {
        return this.apiId;
    }

    @Override
    public String apiHash() {
        return this.apiHash;
    }

    @Override
    public String botAuthToken() {
        return this.botAuthToken;
    }

    public final ImmutableImportBotAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableImportBotAuthorization(value, this.flags, this.apiId, this.apiHash, this.botAuthToken);
    }

    public final ImmutableImportBotAuthorization withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableImportBotAuthorization(this.identifier, value, this.apiId, this.apiHash, this.botAuthToken);
    }

    public final ImmutableImportBotAuthorization withApiId(int value) {
        if (this.apiId == value) {
            return this;
        }
        return new ImmutableImportBotAuthorization(this.identifier, this.flags, value, this.apiHash, this.botAuthToken);
    }

    public final ImmutableImportBotAuthorization withApiHash(String value) {
        String newValue = Objects.requireNonNull(value, "apiHash");
        if (this.apiHash.equals(newValue)) {
            return this;
        }
        return new ImmutableImportBotAuthorization(this.identifier, this.flags, this.apiId, newValue, this.botAuthToken);
    }

    public final ImmutableImportBotAuthorization withBotAuthToken(String value) {
        String newValue = Objects.requireNonNull(value, "botAuthToken");
        if (this.botAuthToken.equals(newValue)) {
            return this;
        }
        return new ImmutableImportBotAuthorization(this.identifier, this.flags, this.apiId, this.apiHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportBotAuthorization && this.equalTo(0, (ImmutableImportBotAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableImportBotAuthorization another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.apiId == another.apiId && this.apiHash.equals(another.apiHash) && this.botAuthToken.equals(another.botAuthToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.apiId;
        h += (h << 5) + this.apiHash.hashCode();
        h += (h << 5) + this.botAuthToken.hashCode();
        return h;
    }

    public String toString() {
        return "ImportBotAuthorization{identifier=" + this.identifier + ", flags=" + this.flags + ", apiId=" + this.apiId + ", apiHash=" + this.apiHash + ", botAuthToken=" + this.botAuthToken + "}";
    }

    public static ImmutableImportBotAuthorization of(int flags, int apiId, String apiHash, String botAuthToken) {
        return new ImmutableImportBotAuthorization(flags, apiId, apiHash, botAuthToken);
    }

    public static ImmutableImportBotAuthorization copyOf(ImportBotAuthorization instance) {
        if (instance instanceof ImmutableImportBotAuthorization) {
            return (ImmutableImportBotAuthorization)instance;
        }
        return ImmutableImportBotAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FLAGS = 1L;
        private static final long INIT_BIT_API_ID = 2L;
        private static final long INIT_BIT_API_HASH = 4L;
        private static final long INIT_BIT_BOT_AUTH_TOKEN = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private int apiId;
        private String apiHash;
        private String botAuthToken;

        private Builder() {
        }

        public final Builder from(ImportBotAuthorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ImportBotAuthorization instance;
            long bits = 0L;
            if (object instanceof ImportBotAuthorization) {
                instance = (ImportBotAuthorization)object;
                this.botAuthToken(instance.botAuthToken());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.apiHash(instance.apiHash());
                this.apiId(instance.apiId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder apiId(int apiId) {
            this.apiId = apiId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder apiHash(String apiHash) {
            this.apiHash = Objects.requireNonNull(apiHash, "apiHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder botAuthToken(String botAuthToken) {
            this.botAuthToken = Objects.requireNonNull(botAuthToken, "botAuthToken");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableImportBotAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImportBotAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("apiId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("apiHash");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("botAuthToken");
            }
            return "Cannot build ImportBotAuthorization, some of required attributes are not set " + attributes;
        }
    }
}

