/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.ImportLoginToken;

public final class ImmutableImportLoginToken
implements ImportLoginToken {
    private final int identifier;
    private final ByteBuf token;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableImportLoginToken(Builder builder) {
        this.token = builder.token_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableImportLoginToken(int identifier, ByteBuf token) {
        this.identifier = identifier;
        this.token = token;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ImportLoginToken.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf token() {
        return this.token.duplicate();
    }

    public final ImmutableImportLoginToken withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableImportLoginToken(value, this.token);
    }

    public ImmutableImportLoginToken withToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.token == newValue) {
            return this;
        }
        return new ImmutableImportLoginToken(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportLoginToken && this.equalTo(0, (ImmutableImportLoginToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableImportLoginToken another) {
        return this.identifier == another.identifier && this.token().equals((Object)another.token());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.token().hashCode();
        return h;
    }

    public String toString() {
        return "ImportLoginToken{identifier=" + this.identifier + ", token=" + ByteBufUtil.hexDump((ByteBuf)this.token) + "}";
    }

    public static ImmutableImportLoginToken copyOf(ImportLoginToken instance) {
        if (instance instanceof ImmutableImportLoginToken) {
            return (ImmutableImportLoginToken)instance;
        }
        return ImmutableImportLoginToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf token_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ImportLoginToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ImportLoginToken) {
                instance = (ImportLoginToken)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.token(instance.token());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder token(ByteBuf value) {
            this.token_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableImportLoginToken build() {
            return new ImmutableImportLoginToken(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf token_build() {
            return Objects.requireNonNull(this.token_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableImportLoginToken.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ImportLoginToken, attribute initializers form cycle " + attributes;
        }
    }
}

