/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.LogOut;

public final class ImmutableLogOut
implements LogOut {
    private final int identifier;
    private static final ImmutableLogOut INSTANCE = ImmutableLogOut.validate(new ImmutableLogOut());

    private ImmutableLogOut() {
        this.identifier = LogOut.super.identifier();
    }

    private ImmutableLogOut(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : LogOut.super.identifier();
    }

    private ImmutableLogOut(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableLogOut withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableLogOut.validate(new ImmutableLogOut(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogOut && this.equalTo(0, (ImmutableLogOut)another);
    }

    private boolean equalTo(int synthetic, ImmutableLogOut another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "LogOut{identifier=" + this.identifier + "}";
    }

    public static ImmutableLogOut of() {
        return INSTANCE;
    }

    private static ImmutableLogOut validate(ImmutableLogOut instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableLogOut copyOf(LogOut instance) {
        if (instance instanceof ImmutableLogOut) {
            return (ImmutableLogOut)instance;
        }
        return ImmutableLogOut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(LogOut instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LogOut instance;
            long bits = 0L;
            if (object instanceof LogOut) {
                instance = (LogOut)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableLogOut build() {
            return ImmutableLogOut.validate(new ImmutableLogOut(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

