/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.account.PasswordInputSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.RecoverPassword;

public final class ImmutableRecoverPassword
implements RecoverPassword {
    private final int identifier;
    private final int flags;
    private final String code;
    @Nullable
    private final PasswordInputSettings newSettings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRecoverPassword(String code) {
        this.code = Objects.requireNonNull(code, "code");
        this.newSettings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableRecoverPassword(Builder builder) {
        this.code = builder.code;
        this.newSettings = builder.newSettings;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableRecoverPassword(int identifier, int flags, String code, @Nullable PasswordInputSettings newSettings) {
        this.identifier = identifier;
        this.flags = flags;
        this.code = code;
        this.newSettings = newSettings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return RecoverPassword.super.identifier();
    }

    private int flagsInitialize() {
        return RecoverPassword.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    @Nullable
    public PasswordInputSettings newSettings() {
        return this.newSettings;
    }

    public final ImmutableRecoverPassword withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRecoverPassword(value, this.flags, this.code, this.newSettings);
    }

    public final ImmutableRecoverPassword withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableRecoverPassword(this.identifier, value, this.code, this.newSettings);
    }

    public final ImmutableRecoverPassword withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableRecoverPassword(this.identifier, this.flags, newValue, this.newSettings);
    }

    public final ImmutableRecoverPassword withNewSettings(@Nullable PasswordInputSettings value) {
        if (this.newSettings == value) {
            return this;
        }
        return new ImmutableRecoverPassword(this.identifier, this.flags, this.code, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecoverPassword && this.equalTo(0, (ImmutableRecoverPassword)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecoverPassword another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.code.equals(another.code) && Objects.equals(this.newSettings, another.newSettings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + Objects.hashCode(this.newSettings);
        return h;
    }

    public String toString() {
        return "RecoverPassword{identifier=" + this.identifier + ", flags=" + this.flags + ", code=" + this.code + ", newSettings=" + this.newSettings + "}";
    }

    public static ImmutableRecoverPassword of(String code) {
        return new ImmutableRecoverPassword(code);
    }

    public static ImmutableRecoverPassword copyOf(RecoverPassword instance) {
        if (instance instanceof ImmutableRecoverPassword) {
            return (ImmutableRecoverPassword)instance;
        }
        return ImmutableRecoverPassword.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private String code;
        private PasswordInputSettings newSettings;

        private Builder() {
        }

        public final Builder from(RecoverPassword instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RecoverPassword instance;
            long bits = 0L;
            if (object instanceof RecoverPassword) {
                instance = (RecoverPassword)object;
                this.flags(instance.flags());
                PasswordInputSettings newSettingsValue = instance.newSettings();
                if (newSettingsValue != null) {
                    this.newSettings(newSettingsValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.code(instance.code());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder newSettings(@Nullable PasswordInputSettings newSettings) {
            this.newSettings = newSettings;
            return this;
        }

        public ImmutableRecoverPassword build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecoverPassword(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            return "Cannot build RecoverPassword, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableRecoverPassword.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableRecoverPassword.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build RecoverPassword, attribute initializers form cycle " + attributes;
        }
    }
}

