/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.RequestPasswordRecovery;

public final class ImmutableRequestPasswordRecovery
implements RequestPasswordRecovery {
    private final int identifier;
    private static final ImmutableRequestPasswordRecovery INSTANCE = ImmutableRequestPasswordRecovery.validate(new ImmutableRequestPasswordRecovery());

    private ImmutableRequestPasswordRecovery() {
        this.identifier = RequestPasswordRecovery.super.identifier();
    }

    private ImmutableRequestPasswordRecovery(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : RequestPasswordRecovery.super.identifier();
    }

    private ImmutableRequestPasswordRecovery(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableRequestPasswordRecovery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableRequestPasswordRecovery.validate(new ImmutableRequestPasswordRecovery(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestPasswordRecovery && this.equalTo(0, (ImmutableRequestPasswordRecovery)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequestPasswordRecovery another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "RequestPasswordRecovery{identifier=" + this.identifier + "}";
    }

    public static ImmutableRequestPasswordRecovery of() {
        return INSTANCE;
    }

    private static ImmutableRequestPasswordRecovery validate(ImmutableRequestPasswordRecovery instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableRequestPasswordRecovery copyOf(RequestPasswordRecovery instance) {
        if (instance instanceof ImmutableRequestPasswordRecovery) {
            return (ImmutableRequestPasswordRecovery)instance;
        }
        return ImmutableRequestPasswordRecovery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(RequestPasswordRecovery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RequestPasswordRecovery instance;
            long bits = 0L;
            if (object instanceof RequestPasswordRecovery) {
                instance = (RequestPasswordRecovery)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableRequestPasswordRecovery build() {
            return ImmutableRequestPasswordRecovery.validate(new ImmutableRequestPasswordRecovery(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

