/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.ResendCode;

public final class ImmutableResendCode
implements ResendCode {
    private final int identifier;
    private final String phoneNumber;
    private final String phoneCodeHash;

    private ImmutableResendCode(String phoneNumber, String phoneCodeHash) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
        this.identifier = ResendCode.super.identifier();
    }

    private ImmutableResendCode(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.phoneCodeHash = builder.phoneCodeHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResendCode.super.identifier();
    }

    private ImmutableResendCode(int identifier, String phoneNumber, String phoneCodeHash) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.phoneCodeHash = phoneCodeHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String phoneCodeHash() {
        return this.phoneCodeHash;
    }

    public final ImmutableResendCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResendCode(value, this.phoneNumber, this.phoneCodeHash);
    }

    public final ImmutableResendCode withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableResendCode(this.identifier, newValue, this.phoneCodeHash);
    }

    public final ImmutableResendCode withPhoneCodeHash(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCodeHash");
        if (this.phoneCodeHash.equals(newValue)) {
            return this;
        }
        return new ImmutableResendCode(this.identifier, this.phoneNumber, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResendCode && this.equalTo(0, (ImmutableResendCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableResendCode another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.phoneCodeHash.equals(another.phoneCodeHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.phoneCodeHash.hashCode();
        return h;
    }

    public String toString() {
        return "ResendCode{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", phoneCodeHash=" + this.phoneCodeHash + "}";
    }

    public static ImmutableResendCode of(String phoneNumber, String phoneCodeHash) {
        return new ImmutableResendCode(phoneNumber, phoneCodeHash);
    }

    public static ImmutableResendCode copyOf(ResendCode instance) {
        if (instance instanceof ImmutableResendCode) {
            return (ImmutableResendCode)instance;
        }
        return ImmutableResendCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_PHONE_CODE_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private String phoneCodeHash;

        private Builder() {
        }

        public final Builder from(ResendCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResendCode instance;
            long bits = 0L;
            if (object instanceof ResendCode) {
                instance = (ResendCode)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneNumber(instance.phoneNumber());
                this.phoneCodeHash(instance.phoneCodeHash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phoneCodeHash(String phoneCodeHash) {
            this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableResendCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResendCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phoneCodeHash");
            }
            return "Cannot build ResendCode, some of required attributes are not set " + attributes;
        }
    }
}

