/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.CodeSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.SendCode;

public final class ImmutableSendCode
implements SendCode {
    private final int identifier;
    private final String phoneNumber;
    private final int apiId;
    private final String apiHash;
    private final CodeSettings settings;

    private ImmutableSendCode(String phoneNumber, int apiId, String apiHash, CodeSettings settings) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.apiId = apiId;
        this.apiHash = Objects.requireNonNull(apiHash, "apiHash");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = SendCode.super.identifier();
    }

    private ImmutableSendCode(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.apiId = builder.apiId;
        this.apiHash = builder.apiHash;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendCode.super.identifier();
    }

    private ImmutableSendCode(int identifier, String phoneNumber, int apiId, String apiHash, CodeSettings settings) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.apiId = apiId;
        this.apiHash = apiHash;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public int apiId() {
        return this.apiId;
    }

    @Override
    public String apiHash() {
        return this.apiHash;
    }

    @Override
    public CodeSettings settings() {
        return this.settings;
    }

    public final ImmutableSendCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendCode(value, this.phoneNumber, this.apiId, this.apiHash, this.settings);
    }

    public final ImmutableSendCode withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableSendCode(this.identifier, newValue, this.apiId, this.apiHash, this.settings);
    }

    public final ImmutableSendCode withApiId(int value) {
        if (this.apiId == value) {
            return this;
        }
        return new ImmutableSendCode(this.identifier, this.phoneNumber, value, this.apiHash, this.settings);
    }

    public final ImmutableSendCode withApiHash(String value) {
        String newValue = Objects.requireNonNull(value, "apiHash");
        if (this.apiHash.equals(newValue)) {
            return this;
        }
        return new ImmutableSendCode(this.identifier, this.phoneNumber, this.apiId, newValue, this.settings);
    }

    public final ImmutableSendCode withSettings(CodeSettings value) {
        if (this.settings == value) {
            return this;
        }
        CodeSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableSendCode(this.identifier, this.phoneNumber, this.apiId, this.apiHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendCode && this.equalTo(0, (ImmutableSendCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendCode another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.apiId == another.apiId && this.apiHash.equals(another.apiHash) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.apiId;
        h += (h << 5) + this.apiHash.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "SendCode{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", apiId=" + this.apiId + ", apiHash=" + this.apiHash + ", settings=" + this.settings + "}";
    }

    public static ImmutableSendCode of(String phoneNumber, int apiId, String apiHash, CodeSettings settings) {
        return new ImmutableSendCode(phoneNumber, apiId, apiHash, settings);
    }

    public static ImmutableSendCode copyOf(SendCode instance) {
        if (instance instanceof ImmutableSendCode) {
            return (ImmutableSendCode)instance;
        }
        return ImmutableSendCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_API_ID = 2L;
        private static final long INIT_BIT_API_HASH = 4L;
        private static final long INIT_BIT_SETTINGS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private int apiId;
        private String apiHash;
        private CodeSettings settings;

        private Builder() {
        }

        public final Builder from(SendCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendCode instance;
            long bits = 0L;
            if (object instanceof SendCode) {
                instance = (SendCode)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.phoneNumber(instance.phoneNumber());
                this.apiHash(instance.apiHash());
                this.apiId(instance.apiId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder apiId(int apiId) {
            this.apiId = apiId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder apiHash(String apiHash) {
            this.apiHash = Objects.requireNonNull(apiHash, "apiHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder settings(CodeSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSendCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("apiId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("apiHash");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build SendCode, some of required attributes are not set " + attributes;
        }
    }
}

