/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.SignIn;

public final class ImmutableSignIn
implements SignIn {
    private final int identifier;
    private final String phoneNumber;
    private final String phoneCodeHash;
    private final String phoneCode;

    private ImmutableSignIn(String phoneNumber, String phoneCodeHash, String phoneCode) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
        this.phoneCode = Objects.requireNonNull(phoneCode, "phoneCode");
        this.identifier = SignIn.super.identifier();
    }

    private ImmutableSignIn(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.phoneCodeHash = builder.phoneCodeHash;
        this.phoneCode = builder.phoneCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SignIn.super.identifier();
    }

    private ImmutableSignIn(int identifier, String phoneNumber, String phoneCodeHash, String phoneCode) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.phoneCodeHash = phoneCodeHash;
        this.phoneCode = phoneCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String phoneCodeHash() {
        return this.phoneCodeHash;
    }

    @Override
    public String phoneCode() {
        return this.phoneCode;
    }

    public final ImmutableSignIn withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSignIn(value, this.phoneNumber, this.phoneCodeHash, this.phoneCode);
    }

    public final ImmutableSignIn withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableSignIn(this.identifier, newValue, this.phoneCodeHash, this.phoneCode);
    }

    public final ImmutableSignIn withPhoneCodeHash(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCodeHash");
        if (this.phoneCodeHash.equals(newValue)) {
            return this;
        }
        return new ImmutableSignIn(this.identifier, this.phoneNumber, newValue, this.phoneCode);
    }

    public final ImmutableSignIn withPhoneCode(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCode");
        if (this.phoneCode.equals(newValue)) {
            return this;
        }
        return new ImmutableSignIn(this.identifier, this.phoneNumber, this.phoneCodeHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignIn && this.equalTo(0, (ImmutableSignIn)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignIn another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.phoneCodeHash.equals(another.phoneCodeHash) && this.phoneCode.equals(another.phoneCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.phoneCodeHash.hashCode();
        h += (h << 5) + this.phoneCode.hashCode();
        return h;
    }

    public String toString() {
        return "SignIn{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", phoneCodeHash=" + this.phoneCodeHash + ", phoneCode=" + this.phoneCode + "}";
    }

    public static ImmutableSignIn of(String phoneNumber, String phoneCodeHash, String phoneCode) {
        return new ImmutableSignIn(phoneNumber, phoneCodeHash, phoneCode);
    }

    public static ImmutableSignIn copyOf(SignIn instance) {
        if (instance instanceof ImmutableSignIn) {
            return (ImmutableSignIn)instance;
        }
        return ImmutableSignIn.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_PHONE_CODE_HASH = 2L;
        private static final long INIT_BIT_PHONE_CODE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private String phoneCodeHash;
        private String phoneCode;

        private Builder() {
        }

        public final Builder from(SignIn instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SignIn instance;
            long bits = 0L;
            if (object instanceof SignIn) {
                instance = (SignIn)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneCode(instance.phoneCode());
                this.phoneNumber(instance.phoneNumber());
                this.phoneCodeHash(instance.phoneCodeHash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phoneCodeHash(String phoneCodeHash) {
            this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder phoneCode(String phoneCode) {
            this.phoneCode = Objects.requireNonNull(phoneCode, "phoneCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSignIn build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignIn(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phoneCodeHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("phoneCode");
            }
            return "Cannot build SignIn, some of required attributes are not set " + attributes;
        }
    }
}

