/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.SignUp;

public final class ImmutableSignUp
implements SignUp {
    private final int identifier;
    private final String phoneNumber;
    private final String phoneCodeHash;
    private final String firstName;
    private final String lastName;

    private ImmutableSignUp(String phoneNumber, String phoneCodeHash, String firstName, String lastName) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.identifier = SignUp.super.identifier();
    }

    private ImmutableSignUp(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.phoneCodeHash = builder.phoneCodeHash;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SignUp.super.identifier();
    }

    private ImmutableSignUp(int identifier, String phoneNumber, String phoneCodeHash, String firstName, String lastName) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.phoneCodeHash = phoneCodeHash;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String phoneCodeHash() {
        return this.phoneCodeHash;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    public final ImmutableSignUp withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSignUp(value, this.phoneNumber, this.phoneCodeHash, this.firstName, this.lastName);
    }

    public final ImmutableSignUp withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableSignUp(this.identifier, newValue, this.phoneCodeHash, this.firstName, this.lastName);
    }

    public final ImmutableSignUp withPhoneCodeHash(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCodeHash");
        if (this.phoneCodeHash.equals(newValue)) {
            return this;
        }
        return new ImmutableSignUp(this.identifier, this.phoneNumber, newValue, this.firstName, this.lastName);
    }

    public final ImmutableSignUp withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableSignUp(this.identifier, this.phoneNumber, this.phoneCodeHash, newValue, this.lastName);
    }

    public final ImmutableSignUp withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableSignUp(this.identifier, this.phoneNumber, this.phoneCodeHash, this.firstName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignUp && this.equalTo(0, (ImmutableSignUp)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignUp another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.phoneCodeHash.equals(another.phoneCodeHash) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.phoneCodeHash.hashCode();
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        return h;
    }

    public String toString() {
        return "SignUp{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", phoneCodeHash=" + this.phoneCodeHash + ", firstName=" + this.firstName + ", lastName=" + this.lastName + "}";
    }

    public static ImmutableSignUp of(String phoneNumber, String phoneCodeHash, String firstName, String lastName) {
        return new ImmutableSignUp(phoneNumber, phoneCodeHash, firstName, lastName);
    }

    public static ImmutableSignUp copyOf(SignUp instance) {
        if (instance instanceof ImmutableSignUp) {
            return (ImmutableSignUp)instance;
        }
        return ImmutableSignUp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_PHONE_CODE_HASH = 2L;
        private static final long INIT_BIT_FIRST_NAME = 4L;
        private static final long INIT_BIT_LAST_NAME = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private String phoneCodeHash;
        private String firstName;
        private String lastName;

        private Builder() {
        }

        public final Builder from(SignUp instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SignUp instance;
            long bits = 0L;
            if (object instanceof SignUp) {
                instance = (SignUp)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.phoneNumber(instance.phoneNumber());
                this.phoneCodeHash(instance.phoneCodeHash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phoneCodeHash(String phoneCodeHash) {
            this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSignUp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignUp(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phoneCodeHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lastName");
            }
            return "Cannot build SignUp, some of required attributes are not set " + attributes;
        }
    }
}

