/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.bots;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.bots.AnswerWebhookJSONQuery;

public final class ImmutableAnswerWebhookJSONQuery
implements AnswerWebhookJSONQuery {
    private final int identifier;
    private final long queryId;
    private final DataJSON data;

    private ImmutableAnswerWebhookJSONQuery(long queryId, DataJSON data) {
        this.queryId = queryId;
        this.data = Objects.requireNonNull(data, "data");
        this.identifier = AnswerWebhookJSONQuery.super.identifier();
    }

    private ImmutableAnswerWebhookJSONQuery(Builder builder) {
        this.queryId = builder.queryId;
        this.data = builder.data;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AnswerWebhookJSONQuery.super.identifier();
    }

    private ImmutableAnswerWebhookJSONQuery(int identifier, long queryId, DataJSON data) {
        this.identifier = identifier;
        this.queryId = queryId;
        this.data = data;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public DataJSON data() {
        return this.data;
    }

    public final ImmutableAnswerWebhookJSONQuery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAnswerWebhookJSONQuery(value, this.queryId, this.data);
    }

    public final ImmutableAnswerWebhookJSONQuery withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableAnswerWebhookJSONQuery(this.identifier, value, this.data);
    }

    public final ImmutableAnswerWebhookJSONQuery withData(DataJSON value) {
        if (this.data == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "data");
        return new ImmutableAnswerWebhookJSONQuery(this.identifier, this.queryId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnswerWebhookJSONQuery && this.equalTo(0, (ImmutableAnswerWebhookJSONQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableAnswerWebhookJSONQuery another) {
        return this.identifier == another.identifier && this.queryId == another.queryId && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "AnswerWebhookJSONQuery{identifier=" + this.identifier + ", queryId=" + this.queryId + ", data=" + this.data + "}";
    }

    public static ImmutableAnswerWebhookJSONQuery of(long queryId, DataJSON data) {
        return new ImmutableAnswerWebhookJSONQuery(queryId, data);
    }

    public static ImmutableAnswerWebhookJSONQuery copyOf(AnswerWebhookJSONQuery instance) {
        if (instance instanceof ImmutableAnswerWebhookJSONQuery) {
            return (ImmutableAnswerWebhookJSONQuery)instance;
        }
        return ImmutableAnswerWebhookJSONQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_DATA = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long queryId;
        private DataJSON data;

        private Builder() {
        }

        public final Builder from(AnswerWebhookJSONQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AnswerWebhookJSONQuery instance;
            long bits = 0L;
            if (object instanceof AnswerWebhookJSONQuery) {
                instance = (AnswerWebhookJSONQuery)object;
                this.data(instance.data());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.queryId(instance.queryId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder data(DataJSON data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAnswerWebhookJSONQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnswerWebhookJSONQuery(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build AnswerWebhookJSONQuery, some of required attributes are not set " + attributes;
        }
    }
}

