/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.bots;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BotCommandScope;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.bots.GetBotCommands;

public final class ImmutableGetBotCommands
implements GetBotCommands {
    private final int identifier;
    private final BotCommandScope scope;
    private final String langCode;

    private ImmutableGetBotCommands(BotCommandScope scope, String langCode) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.identifier = GetBotCommands.super.identifier();
    }

    private ImmutableGetBotCommands(Builder builder) {
        this.scope = builder.scope;
        this.langCode = builder.langCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetBotCommands.super.identifier();
    }

    private ImmutableGetBotCommands(int identifier, BotCommandScope scope, String langCode) {
        this.identifier = identifier;
        this.scope = scope;
        this.langCode = langCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public BotCommandScope scope() {
        return this.scope;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    public final ImmutableGetBotCommands withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetBotCommands(value, this.scope, this.langCode);
    }

    public final ImmutableGetBotCommands withScope(BotCommandScope value) {
        if (this.scope == value) {
            return this;
        }
        BotCommandScope newValue = Objects.requireNonNull(value, "scope");
        return new ImmutableGetBotCommands(this.identifier, newValue, this.langCode);
    }

    public final ImmutableGetBotCommands withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableGetBotCommands(this.identifier, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetBotCommands && this.equalTo(0, (ImmutableGetBotCommands)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetBotCommands another) {
        return this.identifier == another.identifier && this.scope.equals(another.scope) && this.langCode.equals(another.langCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        return h;
    }

    public String toString() {
        return "GetBotCommands{identifier=" + this.identifier + ", scope=" + this.scope + ", langCode=" + this.langCode + "}";
    }

    public static ImmutableGetBotCommands of(BotCommandScope scope, String langCode) {
        return new ImmutableGetBotCommands(scope, langCode);
    }

    public static ImmutableGetBotCommands copyOf(GetBotCommands instance) {
        if (instance instanceof ImmutableGetBotCommands) {
            return (ImmutableGetBotCommands)instance;
        }
        return ImmutableGetBotCommands.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SCOPE = 1L;
        private static final long INIT_BIT_LANG_CODE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private BotCommandScope scope;
        private String langCode;

        private Builder() {
        }

        public final Builder from(GetBotCommands instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetBotCommands instance;
            long bits = 0L;
            if (object instanceof GetBotCommands) {
                instance = (GetBotCommands)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.scope(instance.scope());
                this.langCode(instance.langCode());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder scope(BotCommandScope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetBotCommands build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetBotCommands(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("langCode");
            }
            return "Cannot build GetBotCommands, some of required attributes are not set " + attributes;
        }
    }
}

