/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.bots;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BotCommandScope;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.bots.ResetBotCommands;

public final class ImmutableResetBotCommands
implements ResetBotCommands {
    private final int identifier;
    private final BotCommandScope scope;
    private final String langCode;

    private ImmutableResetBotCommands(BotCommandScope scope, String langCode) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.identifier = ResetBotCommands.super.identifier();
    }

    private ImmutableResetBotCommands(Builder builder) {
        this.scope = builder.scope;
        this.langCode = builder.langCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResetBotCommands.super.identifier();
    }

    private ImmutableResetBotCommands(int identifier, BotCommandScope scope, String langCode) {
        this.identifier = identifier;
        this.scope = scope;
        this.langCode = langCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public BotCommandScope scope() {
        return this.scope;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    public final ImmutableResetBotCommands withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResetBotCommands(value, this.scope, this.langCode);
    }

    public final ImmutableResetBotCommands withScope(BotCommandScope value) {
        if (this.scope == value) {
            return this;
        }
        BotCommandScope newValue = Objects.requireNonNull(value, "scope");
        return new ImmutableResetBotCommands(this.identifier, newValue, this.langCode);
    }

    public final ImmutableResetBotCommands withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableResetBotCommands(this.identifier, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResetBotCommands && this.equalTo(0, (ImmutableResetBotCommands)another);
    }

    private boolean equalTo(int synthetic, ImmutableResetBotCommands another) {
        return this.identifier == another.identifier && this.scope.equals(another.scope) && this.langCode.equals(another.langCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        return h;
    }

    public String toString() {
        return "ResetBotCommands{identifier=" + this.identifier + ", scope=" + this.scope + ", langCode=" + this.langCode + "}";
    }

    public static ImmutableResetBotCommands of(BotCommandScope scope, String langCode) {
        return new ImmutableResetBotCommands(scope, langCode);
    }

    public static ImmutableResetBotCommands copyOf(ResetBotCommands instance) {
        if (instance instanceof ImmutableResetBotCommands) {
            return (ImmutableResetBotCommands)instance;
        }
        return ImmutableResetBotCommands.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SCOPE = 1L;
        private static final long INIT_BIT_LANG_CODE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private BotCommandScope scope;
        private String langCode;

        private Builder() {
        }

        public final Builder from(ResetBotCommands instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResetBotCommands instance;
            long bits = 0L;
            if (object instanceof ResetBotCommands) {
                instance = (ResetBotCommands)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.scope(instance.scope());
                this.langCode(instance.langCode());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder scope(BotCommandScope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableResetBotCommands build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResetBotCommands(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("langCode");
            }
            return "Cannot build ResetBotCommands, some of required attributes are not set " + attributes;
        }
    }
}

