/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.bots;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.bots.SendCustomRequest;

public final class ImmutableSendCustomRequest
implements SendCustomRequest {
    private final int identifier;
    private final String customMethod;
    private final DataJSON params;

    private ImmutableSendCustomRequest(String customMethod, DataJSON params) {
        this.customMethod = Objects.requireNonNull(customMethod, "customMethod");
        this.params = Objects.requireNonNull(params, "params");
        this.identifier = SendCustomRequest.super.identifier();
    }

    private ImmutableSendCustomRequest(Builder builder) {
        this.customMethod = builder.customMethod;
        this.params = builder.params;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendCustomRequest.super.identifier();
    }

    private ImmutableSendCustomRequest(int identifier, String customMethod, DataJSON params) {
        this.identifier = identifier;
        this.customMethod = customMethod;
        this.params = params;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String customMethod() {
        return this.customMethod;
    }

    @Override
    public DataJSON params() {
        return this.params;
    }

    public final ImmutableSendCustomRequest withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendCustomRequest(value, this.customMethod, this.params);
    }

    public final ImmutableSendCustomRequest withCustomMethod(String value) {
        String newValue = Objects.requireNonNull(value, "customMethod");
        if (this.customMethod.equals(newValue)) {
            return this;
        }
        return new ImmutableSendCustomRequest(this.identifier, newValue, this.params);
    }

    public final ImmutableSendCustomRequest withParams(DataJSON value) {
        if (this.params == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "params");
        return new ImmutableSendCustomRequest(this.identifier, this.customMethod, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendCustomRequest && this.equalTo(0, (ImmutableSendCustomRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendCustomRequest another) {
        return this.identifier == another.identifier && this.customMethod.equals(another.customMethod) && this.params.equals(another.params);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.customMethod.hashCode();
        h += (h << 5) + this.params.hashCode();
        return h;
    }

    public String toString() {
        return "SendCustomRequest{identifier=" + this.identifier + ", customMethod=" + this.customMethod + ", params=" + this.params + "}";
    }

    public static ImmutableSendCustomRequest of(String customMethod, DataJSON params) {
        return new ImmutableSendCustomRequest(customMethod, params);
    }

    public static ImmutableSendCustomRequest copyOf(SendCustomRequest instance) {
        if (instance instanceof ImmutableSendCustomRequest) {
            return (ImmutableSendCustomRequest)instance;
        }
        return ImmutableSendCustomRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CUSTOM_METHOD = 1L;
        private static final long INIT_BIT_PARAMS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String customMethod;
        private DataJSON params;

        private Builder() {
        }

        public final Builder from(SendCustomRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendCustomRequest instance;
            long bits = 0L;
            if (object instanceof SendCustomRequest) {
                instance = (SendCustomRequest)object;
                this.params(instance.params());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.customMethod(instance.customMethod());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder customMethod(String customMethod) {
            this.customMethod = Objects.requireNonNull(customMethod, "customMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder params(DataJSON params) {
            this.params = Objects.requireNonNull(params, "params");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSendCustomRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendCustomRequest(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("customMethod");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("params");
            }
            return "Cannot build SendCustomRequest, some of required attributes are not set " + attributes;
        }
    }
}

