/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.bots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.BotCommand;
import telegram4j.tl.BotCommandScope;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.bots.SetBotCommands;

public final class ImmutableSetBotCommands
implements SetBotCommands {
    private final int identifier;
    private final BotCommandScope scope;
    private final String langCode;
    private final List<BotCommand> commands;

    private ImmutableSetBotCommands(BotCommandScope scope, String langCode) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.commands = Collections.emptyList();
        this.identifier = SetBotCommands.super.identifier();
    }

    private ImmutableSetBotCommands(Builder builder) {
        this.scope = builder.scope;
        this.langCode = builder.langCode;
        this.commands = ImmutableSetBotCommands.createUnmodifiableList(true, builder.commands);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetBotCommands.super.identifier();
    }

    private ImmutableSetBotCommands(int identifier, BotCommandScope scope, String langCode, List<BotCommand> commands) {
        this.identifier = identifier;
        this.scope = scope;
        this.langCode = langCode;
        this.commands = commands;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public BotCommandScope scope() {
        return this.scope;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    public List<BotCommand> commands() {
        return this.commands;
    }

    public final ImmutableSetBotCommands withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetBotCommands(value, this.scope, this.langCode, this.commands);
    }

    public final ImmutableSetBotCommands withScope(BotCommandScope value) {
        if (this.scope == value) {
            return this;
        }
        BotCommandScope newValue = Objects.requireNonNull(value, "scope");
        return new ImmutableSetBotCommands(this.identifier, newValue, this.langCode, this.commands);
    }

    public final ImmutableSetBotCommands withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableSetBotCommands(this.identifier, this.scope, newValue, this.commands);
    }

    public final ImmutableSetBotCommands withCommands(BotCommand ... elements) {
        List<BotCommand> newValue = ImmutableSetBotCommands.createUnmodifiableList(false, ImmutableSetBotCommands.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSetBotCommands(this.identifier, this.scope, this.langCode, newValue);
    }

    public final ImmutableSetBotCommands withCommands(Iterable<? extends BotCommand> elements) {
        if (this.commands == elements) {
            return this;
        }
        List<BotCommand> newValue = ImmutableSetBotCommands.createUnmodifiableList(false, ImmutableSetBotCommands.createSafeList(elements, true, false));
        return new ImmutableSetBotCommands(this.identifier, this.scope, this.langCode, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetBotCommands && this.equalTo(0, (ImmutableSetBotCommands)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetBotCommands another) {
        return this.identifier == another.identifier && this.scope.equals(another.scope) && this.langCode.equals(another.langCode) && this.commands.equals(another.commands);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + this.commands.hashCode();
        return h;
    }

    public String toString() {
        return "SetBotCommands{identifier=" + this.identifier + ", scope=" + this.scope + ", langCode=" + this.langCode + ", commands=" + this.commands + "}";
    }

    public static ImmutableSetBotCommands of(BotCommandScope scope, String langCode) {
        return new ImmutableSetBotCommands(scope, langCode);
    }

    public static ImmutableSetBotCommands copyOf(SetBotCommands instance) {
        if (instance instanceof ImmutableSetBotCommands) {
            return (ImmutableSetBotCommands)instance;
        }
        return ImmutableSetBotCommands.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SCOPE = 1L;
        private static final long INIT_BIT_LANG_CODE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private BotCommandScope scope;
        private String langCode;
        private List<BotCommand> commands = new ArrayList<BotCommand>();

        private Builder() {
        }

        public final Builder from(SetBotCommands instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetBotCommands instance;
            long bits = 0L;
            if (object instanceof SetBotCommands) {
                instance = (SetBotCommands)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllCommands(instance.commands());
                this.scope(instance.scope());
                this.langCode(instance.langCode());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder scope(BotCommandScope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addCommand(BotCommand element) {
            this.commands.add(Objects.requireNonNull(element, "commands element"));
            return this;
        }

        public final Builder addCommands(BotCommand ... elements) {
            for (BotCommand element : elements) {
                this.commands.add(Objects.requireNonNull(element, "commands element"));
            }
            return this;
        }

        public final Builder commands(Iterable<? extends BotCommand> elements) {
            this.commands.clear();
            return this.addAllCommands(elements);
        }

        public final Builder addAllCommands(Iterable<? extends BotCommand> elements) {
            for (BotCommand botCommand : elements) {
                this.commands.add(Objects.requireNonNull(botCommand, "commands element"));
            }
            return this;
        }

        public ImmutableSetBotCommands build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetBotCommands(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("langCode");
            }
            return "Cannot build SetBotCommands, some of required attributes are not set " + attributes;
        }
    }
}

