/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.bots;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BotMenuButton;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.bots.SetBotMenuButton;

public final class ImmutableSetBotMenuButton
implements SetBotMenuButton {
    private final int identifier;
    private final InputUser userId;
    private final BotMenuButton button;

    private ImmutableSetBotMenuButton(InputUser userId, BotMenuButton button) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.button = Objects.requireNonNull(button, "button");
        this.identifier = SetBotMenuButton.super.identifier();
    }

    private ImmutableSetBotMenuButton(Builder builder) {
        this.userId = builder.userId;
        this.button = builder.button;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetBotMenuButton.super.identifier();
    }

    private ImmutableSetBotMenuButton(int identifier, InputUser userId, BotMenuButton button) {
        this.identifier = identifier;
        this.userId = userId;
        this.button = button;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public BotMenuButton button() {
        return this.button;
    }

    public final ImmutableSetBotMenuButton withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetBotMenuButton(value, this.userId, this.button);
    }

    public final ImmutableSetBotMenuButton withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableSetBotMenuButton(this.identifier, newValue, this.button);
    }

    public final ImmutableSetBotMenuButton withButton(BotMenuButton value) {
        if (this.button == value) {
            return this;
        }
        BotMenuButton newValue = Objects.requireNonNull(value, "button");
        return new ImmutableSetBotMenuButton(this.identifier, this.userId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetBotMenuButton && this.equalTo(0, (ImmutableSetBotMenuButton)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetBotMenuButton another) {
        return this.identifier == another.identifier && this.userId.equals(another.userId) && this.button.equals(another.button);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.button.hashCode();
        return h;
    }

    public String toString() {
        return "SetBotMenuButton{identifier=" + this.identifier + ", userId=" + this.userId + ", button=" + this.button + "}";
    }

    public static ImmutableSetBotMenuButton of(InputUser userId, BotMenuButton button) {
        return new ImmutableSetBotMenuButton(userId, button);
    }

    public static ImmutableSetBotMenuButton copyOf(SetBotMenuButton instance) {
        if (instance instanceof ImmutableSetBotMenuButton) {
            return (ImmutableSetBotMenuButton)instance;
        }
        return ImmutableSetBotMenuButton.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_BUTTON = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputUser userId;
        private BotMenuButton button;

        private Builder() {
        }

        public final Builder from(SetBotMenuButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetBotMenuButton instance;
            long bits = 0L;
            if (object instanceof SetBotMenuButton) {
                instance = (SetBotMenuButton)object;
                this.button(instance.button());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder button(BotMenuButton button) {
            this.button = Objects.requireNonNull(button, "button");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetBotMenuButton build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetBotMenuButton(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("button");
            }
            return "Cannot build SetBotMenuButton, some of required attributes are not set " + attributes;
        }
    }
}

