/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.CreateChannel;

public final class ImmutableCreateChannel
implements CreateChannel {
    private final int identifier;
    private final int flags;
    private final boolean broadcast;
    private final boolean megagroup;
    private final boolean forImport;
    private final String title;
    private final String about;
    @Nullable
    private final InputGeoPoint geoPoint;
    @Nullable
    private final String address;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCreateChannel(String title, String about) {
        this.title = Objects.requireNonNull(title, "title");
        this.about = Objects.requireNonNull(about, "about");
        this.geoPoint = null;
        this.address = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.broadcast = this.initShim.broadcast();
        this.megagroup = this.initShim.megagroup();
        this.forImport = this.initShim.forImport();
        this.initShim = null;
    }

    private ImmutableCreateChannel(Builder builder) {
        this.title = builder.title;
        this.about = builder.about;
        this.geoPoint = builder.geoPoint;
        this.address = builder.address;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.broadcastIsSet()) {
            this.initShim.broadcast(builder.broadcast);
        }
        if (builder.megagroupIsSet()) {
            this.initShim.megagroup(builder.megagroup);
        }
        if (builder.forImportIsSet()) {
            this.initShim.forImport(builder.forImport);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.broadcast = this.initShim.broadcast();
        this.megagroup = this.initShim.megagroup();
        this.forImport = this.initShim.forImport();
        this.initShim = null;
    }

    private ImmutableCreateChannel(int identifier, int flags, boolean broadcast, boolean megagroup, boolean forImport, String title, String about, @Nullable InputGeoPoint geoPoint, @Nullable String address) {
        this.identifier = identifier;
        this.flags = flags;
        this.broadcast = broadcast;
        this.megagroup = megagroup;
        this.forImport = forImport;
        this.title = title;
        this.about = about;
        this.geoPoint = geoPoint;
        this.address = address;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return CreateChannel.super.identifier();
    }

    private int flagsInitialize() {
        return CreateChannel.super.flags();
    }

    private boolean broadcastInitialize() {
        return CreateChannel.super.broadcast();
    }

    private boolean megagroupInitialize() {
        return CreateChannel.super.megagroup();
    }

    private boolean forImportInitialize() {
        return CreateChannel.super.forImport();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean broadcast() {
        InitShim shim = this.initShim;
        return shim != null ? shim.broadcast() : this.broadcast;
    }

    @Override
    public boolean megagroup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.megagroup() : this.megagroup;
    }

    @Override
    public boolean forImport() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forImport() : this.forImport;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String about() {
        return this.about;
    }

    @Override
    @Nullable
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    @Nullable
    public String address() {
        return this.address;
    }

    public final ImmutableCreateChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCreateChannel(value, this.flags, this.broadcast, this.megagroup, this.forImport, this.title, this.about, this.geoPoint, this.address);
    }

    public final ImmutableCreateChannel withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, value, this.broadcast, this.megagroup, this.forImport, this.title, this.about, this.geoPoint, this.address);
    }

    public final ImmutableCreateChannel withBroadcast(boolean value) {
        if (this.broadcast == value) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, this.flags, value, this.megagroup, this.forImport, this.title, this.about, this.geoPoint, this.address);
    }

    public final ImmutableCreateChannel withMegagroup(boolean value) {
        if (this.megagroup == value) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, this.flags, this.broadcast, value, this.forImport, this.title, this.about, this.geoPoint, this.address);
    }

    public final ImmutableCreateChannel withForImport(boolean value) {
        if (this.forImport == value) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, this.flags, this.broadcast, this.megagroup, value, this.title, this.about, this.geoPoint, this.address);
    }

    public final ImmutableCreateChannel withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, this.flags, this.broadcast, this.megagroup, this.forImport, newValue, this.about, this.geoPoint, this.address);
    }

    public final ImmutableCreateChannel withAbout(String value) {
        String newValue = Objects.requireNonNull(value, "about");
        if (this.about.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, this.flags, this.broadcast, this.megagroup, this.forImport, this.title, newValue, this.geoPoint, this.address);
    }

    public final ImmutableCreateChannel withGeoPoint(@Nullable InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, this.flags, this.broadcast, this.megagroup, this.forImport, this.title, this.about, value, this.address);
    }

    public final ImmutableCreateChannel withAddress(@Nullable String value) {
        if (Objects.equals(this.address, value)) {
            return this;
        }
        return new ImmutableCreateChannel(this.identifier, this.flags, this.broadcast, this.megagroup, this.forImport, this.title, this.about, this.geoPoint, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateChannel && this.equalTo(0, (ImmutableCreateChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateChannel another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.broadcast == another.broadcast && this.megagroup == another.megagroup && this.forImport == another.forImport && this.title.equals(another.title) && this.about.equals(another.about) && Objects.equals(this.geoPoint, another.geoPoint) && Objects.equals(this.address, another.address);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.broadcast);
        h += (h << 5) + Boolean.hashCode(this.megagroup);
        h += (h << 5) + Boolean.hashCode(this.forImport);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.about.hashCode();
        h += (h << 5) + Objects.hashCode(this.geoPoint);
        h += (h << 5) + Objects.hashCode(this.address);
        return h;
    }

    public String toString() {
        return "CreateChannel{identifier=" + this.identifier + ", flags=" + this.flags + ", broadcast=" + this.broadcast + ", megagroup=" + this.megagroup + ", forImport=" + this.forImport + ", title=" + this.title + ", about=" + this.about + ", geoPoint=" + this.geoPoint + ", address=" + this.address + "}";
    }

    public static ImmutableCreateChannel of(String title, String about) {
        return new ImmutableCreateChannel(title, about);
    }

    public static ImmutableCreateChannel copyOf(CreateChannel instance) {
        if (instance instanceof ImmutableCreateChannel) {
            return (ImmutableCreateChannel)instance;
        }
        return ImmutableCreateChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_ABOUT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BROADCAST = 4L;
        private static final long OPT_BIT_MEGAGROUP = 8L;
        private static final long OPT_BIT_FOR_IMPORT = 16L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean broadcast;
        private boolean megagroup;
        private boolean forImport;
        private String title;
        private String about;
        private InputGeoPoint geoPoint;
        private String address;

        private Builder() {
        }

        public final Builder from(CreateChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CreateChannel instance;
            long bits = 0L;
            if (object instanceof CreateChannel) {
                String addressValue;
                instance = (CreateChannel)object;
                this.broadcast(instance.broadcast());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((addressValue = instance.address()) != null) {
                    this.address(addressValue);
                }
                this.flags(instance.flags());
                this.about(instance.about());
                this.title(instance.title());
                InputGeoPoint geoPointValue = instance.geoPoint();
                if (geoPointValue != null) {
                    this.geoPoint(geoPointValue);
                }
                this.forImport(instance.forImport());
                this.megagroup(instance.megagroup());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.optBits |= 4L;
            return this;
        }

        public final Builder megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.optBits |= 8L;
            return this;
        }

        public final Builder forImport(boolean forImport) {
            this.forImport = forImport;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder about(String about) {
            this.about = Objects.requireNonNull(about, "about");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder geoPoint(@Nullable InputGeoPoint geoPoint) {
            this.geoPoint = geoPoint;
            return this;
        }

        public final Builder address(@Nullable String address) {
            this.address = address;
            return this;
        }

        public ImmutableCreateChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean broadcastIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean megagroupIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean forImportIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("about");
            }
            return "Cannot build CreateChannel, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte broadcastBuildStage = 0;
        private boolean broadcast;
        private byte megagroupBuildStage = 0;
        private boolean megagroup;
        private byte forImportBuildStage = 0;
        private boolean forImport;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCreateChannel.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableCreateChannel.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean broadcast() {
            if (this.broadcastBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.broadcastBuildStage == 0) {
                this.broadcastBuildStage = (byte)-1;
                this.broadcast = ImmutableCreateChannel.this.broadcastInitialize();
                this.broadcastBuildStage = 1;
            }
            return this.broadcast;
        }

        void broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.broadcastBuildStage = 1;
        }

        boolean megagroup() {
            if (this.megagroupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.megagroupBuildStage == 0) {
                this.megagroupBuildStage = (byte)-1;
                this.megagroup = ImmutableCreateChannel.this.megagroupInitialize();
                this.megagroupBuildStage = 1;
            }
            return this.megagroup;
        }

        void megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.megagroupBuildStage = 1;
        }

        boolean forImport() {
            if (this.forImportBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forImportBuildStage == 0) {
                this.forImportBuildStage = (byte)-1;
                this.forImport = ImmutableCreateChannel.this.forImportInitialize();
                this.forImportBuildStage = 1;
            }
            return this.forImport;
        }

        void forImport(boolean forImport) {
            this.forImport = forImport;
            this.forImportBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.broadcastBuildStage == -1) {
                attributes.add("broadcast");
            }
            if (this.megagroupBuildStage == -1) {
                attributes.add("megagroup");
            }
            if (this.forImportBuildStage == -1) {
                attributes.add("forImport");
            }
            return "Cannot build CreateChannel, attribute initializers form cycle " + attributes;
        }
    }
}

