/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.DeleteHistory;

public final class ImmutableDeleteHistory
implements DeleteHistory {
    private final int identifier;
    private final int flags;
    private final boolean forEveryone;
    private final InputChannel channel;
    private final int maxId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDeleteHistory(InputChannel channel, int maxId) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.maxId = maxId;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.forEveryone = this.initShim.forEveryone();
        this.initShim = null;
    }

    private ImmutableDeleteHistory(Builder builder) {
        this.channel = builder.channel;
        this.maxId = builder.maxId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.forEveryoneIsSet()) {
            this.initShim.forEveryone(builder.forEveryone);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.forEveryone = this.initShim.forEveryone();
        this.initShim = null;
    }

    private ImmutableDeleteHistory(int identifier, int flags, boolean forEveryone, InputChannel channel, int maxId) {
        this.identifier = identifier;
        this.flags = flags;
        this.forEveryone = forEveryone;
        this.channel = channel;
        this.maxId = maxId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DeleteHistory.super.identifier();
    }

    private int flagsInitialize() {
        return DeleteHistory.super.flags();
    }

    private boolean forEveryoneInitialize() {
        return DeleteHistory.super.forEveryone();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean forEveryone() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forEveryone() : this.forEveryone;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    public final ImmutableDeleteHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteHistory(value, this.flags, this.forEveryone, this.channel, this.maxId);
    }

    public final ImmutableDeleteHistory withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, value, this.forEveryone, this.channel, this.maxId);
    }

    public final ImmutableDeleteHistory withForEveryone(boolean value) {
        if (this.forEveryone == value) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, this.flags, value, this.channel, this.maxId);
    }

    public final ImmutableDeleteHistory withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableDeleteHistory(this.identifier, this.flags, this.forEveryone, newValue, this.maxId);
    }

    public final ImmutableDeleteHistory withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, this.flags, this.forEveryone, this.channel, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteHistory && this.equalTo(0, (ImmutableDeleteHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteHistory another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.forEveryone == another.forEveryone && this.channel.equals(another.channel) && this.maxId == another.maxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.forEveryone);
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.maxId;
        return h;
    }

    public String toString() {
        return "DeleteHistory{identifier=" + this.identifier + ", flags=" + this.flags + ", forEveryone=" + this.forEveryone + ", channel=" + this.channel + ", maxId=" + this.maxId + "}";
    }

    public static ImmutableDeleteHistory of(InputChannel channel, int maxId) {
        return new ImmutableDeleteHistory(channel, maxId);
    }

    public static ImmutableDeleteHistory copyOf(DeleteHistory instance) {
        if (instance instanceof ImmutableDeleteHistory) {
            return (ImmutableDeleteHistory)instance;
        }
        return ImmutableDeleteHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_FOR_EVERYONE = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean forEveryone;
        private InputChannel channel;
        private int maxId;

        private Builder() {
        }

        public final Builder from(DeleteHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DeleteHistory instance;
            long bits = 0L;
            if (object instanceof DeleteHistory) {
                instance = (DeleteHistory)object;
                this.flags(instance.flags());
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.forEveryone(instance.forEveryone());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder forEveryone(boolean forEveryone) {
            this.forEveryone = forEveryone;
            this.optBits |= 4L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDeleteHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean forEveryoneIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            return "Cannot build DeleteHistory, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte forEveryoneBuildStage = 0;
        private boolean forEveryone;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDeleteHistory.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDeleteHistory.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean forEveryone() {
            if (this.forEveryoneBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forEveryoneBuildStage == 0) {
                this.forEveryoneBuildStage = (byte)-1;
                this.forEveryone = ImmutableDeleteHistory.this.forEveryoneInitialize();
                this.forEveryoneBuildStage = 1;
            }
            return this.forEveryone;
        }

        void forEveryone(boolean forEveryone) {
            this.forEveryone = forEveryone;
            this.forEveryoneBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.forEveryoneBuildStage == -1) {
                attributes.add("forEveryone");
            }
            return "Cannot build DeleteHistory, attribute initializers form cycle " + attributes;
        }
    }
}

