/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatAdminRights;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.EditAdmin;

public final class ImmutableEditAdmin
implements EditAdmin {
    private final int identifier;
    private final InputChannel channel;
    private final InputUser userId;
    private final ChatAdminRights adminRights;
    private final String rank;

    private ImmutableEditAdmin(InputChannel channel, InputUser userId, ChatAdminRights adminRights, String rank) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.userId = Objects.requireNonNull(userId, "userId");
        this.adminRights = Objects.requireNonNull(adminRights, "adminRights");
        this.rank = Objects.requireNonNull(rank, "rank");
        this.identifier = EditAdmin.super.identifier();
    }

    private ImmutableEditAdmin(Builder builder) {
        this.channel = builder.channel;
        this.userId = builder.userId;
        this.adminRights = builder.adminRights;
        this.rank = builder.rank;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditAdmin.super.identifier();
    }

    private ImmutableEditAdmin(int identifier, InputChannel channel, InputUser userId, ChatAdminRights adminRights, String rank) {
        this.identifier = identifier;
        this.channel = channel;
        this.userId = userId;
        this.adminRights = adminRights;
        this.rank = rank;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public ChatAdminRights adminRights() {
        return this.adminRights;
    }

    @Override
    public String rank() {
        return this.rank;
    }

    public final ImmutableEditAdmin withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditAdmin(value, this.channel, this.userId, this.adminRights, this.rank);
    }

    public final ImmutableEditAdmin withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableEditAdmin(this.identifier, newValue, this.userId, this.adminRights, this.rank);
    }

    public final ImmutableEditAdmin withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableEditAdmin(this.identifier, this.channel, newValue, this.adminRights, this.rank);
    }

    public final ImmutableEditAdmin withAdminRights(ChatAdminRights value) {
        if (this.adminRights == value) {
            return this;
        }
        ChatAdminRights newValue = Objects.requireNonNull(value, "adminRights");
        return new ImmutableEditAdmin(this.identifier, this.channel, this.userId, newValue, this.rank);
    }

    public final ImmutableEditAdmin withRank(String value) {
        String newValue = Objects.requireNonNull(value, "rank");
        if (this.rank.equals(newValue)) {
            return this;
        }
        return new ImmutableEditAdmin(this.identifier, this.channel, this.userId, this.adminRights, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditAdmin && this.equalTo(0, (ImmutableEditAdmin)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditAdmin another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.userId.equals(another.userId) && this.adminRights.equals(another.adminRights) && this.rank.equals(another.rank);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.adminRights.hashCode();
        h += (h << 5) + this.rank.hashCode();
        return h;
    }

    public String toString() {
        return "EditAdmin{identifier=" + this.identifier + ", channel=" + this.channel + ", userId=" + this.userId + ", adminRights=" + this.adminRights + ", rank=" + this.rank + "}";
    }

    public static ImmutableEditAdmin of(InputChannel channel, InputUser userId, ChatAdminRights adminRights, String rank) {
        return new ImmutableEditAdmin(channel, userId, adminRights, rank);
    }

    public static ImmutableEditAdmin copyOf(EditAdmin instance) {
        if (instance instanceof ImmutableEditAdmin) {
            return (ImmutableEditAdmin)instance;
        }
        return ImmutableEditAdmin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_ADMIN_RIGHTS = 4L;
        private static final long INIT_BIT_RANK = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputUser userId;
        private ChatAdminRights adminRights;
        private String rank;

        private Builder() {
        }

        public final Builder from(EditAdmin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditAdmin instance;
            long bits = 0L;
            if (object instanceof EditAdmin) {
                instance = (EditAdmin)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.rank(instance.rank());
                this.userId(instance.userId());
                this.adminRights(instance.adminRights());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder adminRights(ChatAdminRights adminRights) {
            this.adminRights = Objects.requireNonNull(adminRights, "adminRights");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder rank(String rank) {
            this.rank = Objects.requireNonNull(rank, "rank");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableEditAdmin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditAdmin(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("adminRights");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("rank");
            }
            return "Cannot build EditAdmin, some of required attributes are not set " + attributes;
        }
    }
}

