/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatBannedRights;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.EditBanned;

public final class ImmutableEditBanned
implements EditBanned {
    private final int identifier;
    private final InputChannel channel;
    private final InputPeer participant;
    private final ChatBannedRights bannedRights;

    private ImmutableEditBanned(InputChannel channel, InputPeer participant, ChatBannedRights bannedRights) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.participant = Objects.requireNonNull(participant, "participant");
        this.bannedRights = Objects.requireNonNull(bannedRights, "bannedRights");
        this.identifier = EditBanned.super.identifier();
    }

    private ImmutableEditBanned(Builder builder) {
        this.channel = builder.channel;
        this.participant = builder.participant;
        this.bannedRights = builder.bannedRights;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditBanned.super.identifier();
    }

    private ImmutableEditBanned(int identifier, InputChannel channel, InputPeer participant, ChatBannedRights bannedRights) {
        this.identifier = identifier;
        this.channel = channel;
        this.participant = participant;
        this.bannedRights = bannedRights;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputPeer participant() {
        return this.participant;
    }

    @Override
    public ChatBannedRights bannedRights() {
        return this.bannedRights;
    }

    public final ImmutableEditBanned withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditBanned(value, this.channel, this.participant, this.bannedRights);
    }

    public final ImmutableEditBanned withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableEditBanned(this.identifier, newValue, this.participant, this.bannedRights);
    }

    public final ImmutableEditBanned withParticipant(InputPeer value) {
        if (this.participant == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "participant");
        return new ImmutableEditBanned(this.identifier, this.channel, newValue, this.bannedRights);
    }

    public final ImmutableEditBanned withBannedRights(ChatBannedRights value) {
        if (this.bannedRights == value) {
            return this;
        }
        ChatBannedRights newValue = Objects.requireNonNull(value, "bannedRights");
        return new ImmutableEditBanned(this.identifier, this.channel, this.participant, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditBanned && this.equalTo(0, (ImmutableEditBanned)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditBanned another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.participant.equals(another.participant) && this.bannedRights.equals(another.bannedRights);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.participant.hashCode();
        h += (h << 5) + this.bannedRights.hashCode();
        return h;
    }

    public String toString() {
        return "EditBanned{identifier=" + this.identifier + ", channel=" + this.channel + ", participant=" + this.participant + ", bannedRights=" + this.bannedRights + "}";
    }

    public static ImmutableEditBanned of(InputChannel channel, InputPeer participant, ChatBannedRights bannedRights) {
        return new ImmutableEditBanned(channel, participant, bannedRights);
    }

    public static ImmutableEditBanned copyOf(EditBanned instance) {
        if (instance instanceof ImmutableEditBanned) {
            return (ImmutableEditBanned)instance;
        }
        return ImmutableEditBanned.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_PARTICIPANT = 2L;
        private static final long INIT_BIT_BANNED_RIGHTS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputPeer participant;
        private ChatBannedRights bannedRights;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditBanned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditBanned) {
                instance = (EditBanned)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.participant(instance.participant());
                this.bannedRights(instance.bannedRights());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder participant(InputPeer participant) {
            this.participant = Objects.requireNonNull(participant, "participant");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bannedRights(ChatBannedRights bannedRights) {
            this.bannedRights = Objects.requireNonNull(bannedRights, "bannedRights");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEditBanned build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditBanned(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("participant");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bannedRights");
            }
            return "Cannot build EditBanned, some of required attributes are not set " + attributes;
        }
    }
}

