/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputCheckPasswordSRP;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.EditCreator;

public final class ImmutableEditCreator
implements EditCreator {
    private final int identifier;
    private final InputChannel channel;
    private final InputUser userId;
    private final InputCheckPasswordSRP password;

    private ImmutableEditCreator(InputChannel channel, InputUser userId, InputCheckPasswordSRP password) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.userId = Objects.requireNonNull(userId, "userId");
        this.password = Objects.requireNonNull(password, "password");
        this.identifier = EditCreator.super.identifier();
    }

    private ImmutableEditCreator(Builder builder) {
        this.channel = builder.channel;
        this.userId = builder.userId;
        this.password = builder.password;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditCreator.super.identifier();
    }

    private ImmutableEditCreator(int identifier, InputChannel channel, InputUser userId, InputCheckPasswordSRP password) {
        this.identifier = identifier;
        this.channel = channel;
        this.userId = userId;
        this.password = password;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public InputCheckPasswordSRP password() {
        return this.password;
    }

    public final ImmutableEditCreator withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditCreator(value, this.channel, this.userId, this.password);
    }

    public final ImmutableEditCreator withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableEditCreator(this.identifier, newValue, this.userId, this.password);
    }

    public final ImmutableEditCreator withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableEditCreator(this.identifier, this.channel, newValue, this.password);
    }

    public final ImmutableEditCreator withPassword(InputCheckPasswordSRP value) {
        if (this.password == value) {
            return this;
        }
        InputCheckPasswordSRP newValue = Objects.requireNonNull(value, "password");
        return new ImmutableEditCreator(this.identifier, this.channel, this.userId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditCreator && this.equalTo(0, (ImmutableEditCreator)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditCreator another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.userId.equals(another.userId) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return "EditCreator{identifier=" + this.identifier + ", channel=" + this.channel + ", userId=" + this.userId + ", password=" + this.password + "}";
    }

    public static ImmutableEditCreator of(InputChannel channel, InputUser userId, InputCheckPasswordSRP password) {
        return new ImmutableEditCreator(channel, userId, password);
    }

    public static ImmutableEditCreator copyOf(EditCreator instance) {
        if (instance instanceof ImmutableEditCreator) {
            return (ImmutableEditCreator)instance;
        }
        return ImmutableEditCreator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_PASSWORD = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputUser userId;
        private InputCheckPasswordSRP password;

        private Builder() {
        }

        public final Builder from(EditCreator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditCreator instance;
            long bits = 0L;
            if (object instanceof EditCreator) {
                instance = (EditCreator)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.password(instance.password());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder password(InputCheckPasswordSRP password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEditCreator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditCreator(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build EditCreator, some of required attributes are not set " + attributes;
        }
    }
}

