/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.EditLocation;

public final class ImmutableEditLocation
implements EditLocation {
    private final int identifier;
    private final InputChannel channel;
    private final InputGeoPoint geoPoint;
    private final String address;

    private ImmutableEditLocation(InputChannel channel, InputGeoPoint geoPoint, String address) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.address = Objects.requireNonNull(address, "address");
        this.identifier = EditLocation.super.identifier();
    }

    private ImmutableEditLocation(Builder builder) {
        this.channel = builder.channel;
        this.geoPoint = builder.geoPoint;
        this.address = builder.address;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditLocation.super.identifier();
    }

    private ImmutableEditLocation(int identifier, InputChannel channel, InputGeoPoint geoPoint, String address) {
        this.identifier = identifier;
        this.channel = channel;
        this.geoPoint = geoPoint;
        this.address = address;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    public String address() {
        return this.address;
    }

    public final ImmutableEditLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditLocation(value, this.channel, this.geoPoint, this.address);
    }

    public final ImmutableEditLocation withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableEditLocation(this.identifier, newValue, this.geoPoint, this.address);
    }

    public final ImmutableEditLocation withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableEditLocation(this.identifier, this.channel, newValue, this.address);
    }

    public final ImmutableEditLocation withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableEditLocation(this.identifier, this.channel, this.geoPoint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditLocation && this.equalTo(0, (ImmutableEditLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditLocation another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.geoPoint.equals(another.geoPoint) && this.address.equals(another.address);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.geoPoint.hashCode();
        h += (h << 5) + this.address.hashCode();
        return h;
    }

    public String toString() {
        return "EditLocation{identifier=" + this.identifier + ", channel=" + this.channel + ", geoPoint=" + this.geoPoint + ", address=" + this.address + "}";
    }

    public static ImmutableEditLocation of(InputChannel channel, InputGeoPoint geoPoint, String address) {
        return new ImmutableEditLocation(channel, geoPoint, address);
    }

    public static ImmutableEditLocation copyOf(EditLocation instance) {
        if (instance instanceof ImmutableEditLocation) {
            return (ImmutableEditLocation)instance;
        }
        return ImmutableEditLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_GEO_POINT = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputGeoPoint geoPoint;
        private String address;

        private Builder() {
        }

        public final Builder from(EditLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditLocation instance;
            long bits = 0L;
            if (object instanceof EditLocation) {
                instance = (EditLocation)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.address(instance.address());
                this.geoPoint(instance.geoPoint());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEditLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("geoPoint");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build EditLocation, some of required attributes are not set " + attributes;
        }
    }
}

