/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputChatPhoto;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.EditPhoto;

public final class ImmutableEditPhoto
implements EditPhoto {
    private final int identifier;
    private final InputChannel channel;
    private final InputChatPhoto photo;

    private ImmutableEditPhoto(InputChannel channel, InputChatPhoto photo) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.photo = Objects.requireNonNull(photo, "photo");
        this.identifier = EditPhoto.super.identifier();
    }

    private ImmutableEditPhoto(Builder builder) {
        this.channel = builder.channel;
        this.photo = builder.photo;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditPhoto.super.identifier();
    }

    private ImmutableEditPhoto(int identifier, InputChannel channel, InputChatPhoto photo) {
        this.identifier = identifier;
        this.channel = channel;
        this.photo = photo;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputChatPhoto photo() {
        return this.photo;
    }

    public final ImmutableEditPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditPhoto(value, this.channel, this.photo);
    }

    public final ImmutableEditPhoto withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableEditPhoto(this.identifier, newValue, this.photo);
    }

    public final ImmutableEditPhoto withPhoto(InputChatPhoto value) {
        if (this.photo == value) {
            return this;
        }
        InputChatPhoto newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableEditPhoto(this.identifier, this.channel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditPhoto && this.equalTo(0, (ImmutableEditPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditPhoto another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.photo.equals(another.photo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.photo.hashCode();
        return h;
    }

    public String toString() {
        return "EditPhoto{identifier=" + this.identifier + ", channel=" + this.channel + ", photo=" + this.photo + "}";
    }

    public static ImmutableEditPhoto of(InputChannel channel, InputChatPhoto photo) {
        return new ImmutableEditPhoto(channel, photo);
    }

    public static ImmutableEditPhoto copyOf(EditPhoto instance) {
        if (instance instanceof ImmutableEditPhoto) {
            return (ImmutableEditPhoto)instance;
        }
        return ImmutableEditPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_PHOTO = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputChatPhoto photo;

        private Builder() {
        }

        public final Builder from(EditPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditPhoto instance;
            long bits = 0L;
            if (object instanceof EditPhoto) {
                instance = (EditPhoto)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.photo(instance.photo());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder photo(InputChatPhoto photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEditPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("photo");
            }
            return "Cannot build EditPhoto, some of required attributes are not set " + attributes;
        }
    }
}

