/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.EditTitle;

public final class ImmutableEditTitle
implements EditTitle {
    private final int identifier;
    private final InputChannel channel;
    private final String title;

    private ImmutableEditTitle(InputChannel channel, String title) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.title = Objects.requireNonNull(title, "title");
        this.identifier = EditTitle.super.identifier();
    }

    private ImmutableEditTitle(Builder builder) {
        this.channel = builder.channel;
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditTitle.super.identifier();
    }

    private ImmutableEditTitle(int identifier, InputChannel channel, String title) {
        this.identifier = identifier;
        this.channel = channel;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableEditTitle withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditTitle(value, this.channel, this.title);
    }

    public final ImmutableEditTitle withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableEditTitle(this.identifier, newValue, this.title);
    }

    public final ImmutableEditTitle withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableEditTitle(this.identifier, this.channel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditTitle && this.equalTo(0, (ImmutableEditTitle)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditTitle another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "EditTitle{identifier=" + this.identifier + ", channel=" + this.channel + ", title=" + this.title + "}";
    }

    public static ImmutableEditTitle of(InputChannel channel, String title) {
        return new ImmutableEditTitle(channel, title);
    }

    public static ImmutableEditTitle copyOf(EditTitle instance) {
        if (instance instanceof ImmutableEditTitle) {
            return (ImmutableEditTitle)instance;
        }
        return ImmutableEditTitle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private String title;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditTitle instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditTitle) {
                instance = (EditTitle)object;
                this.channel(instance.channel());
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEditTitle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditTitle(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build EditTitle, some of required attributes are not set " + attributes;
        }
    }
}

