/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.ExportMessageLink;

public final class ImmutableExportMessageLink
implements ExportMessageLink {
    private final int identifier;
    private final int flags;
    private final boolean grouped;
    private final boolean thread;
    private final InputChannel channel;
    private final int id;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExportMessageLink(InputChannel channel, int id) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.id = id;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.grouped = this.initShim.grouped();
        this.thread = this.initShim.thread();
        this.initShim = null;
    }

    private ImmutableExportMessageLink(Builder builder) {
        this.channel = builder.channel;
        this.id = builder.id;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.groupedIsSet()) {
            this.initShim.grouped(builder.grouped);
        }
        if (builder.threadIsSet()) {
            this.initShim.thread(builder.thread);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.grouped = this.initShim.grouped();
        this.thread = this.initShim.thread();
        this.initShim = null;
    }

    private ImmutableExportMessageLink(int identifier, int flags, boolean grouped, boolean thread, InputChannel channel, int id) {
        this.identifier = identifier;
        this.flags = flags;
        this.grouped = grouped;
        this.thread = thread;
        this.channel = channel;
        this.id = id;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ExportMessageLink.super.identifier();
    }

    private int flagsInitialize() {
        return ExportMessageLink.super.flags();
    }

    private boolean groupedInitialize() {
        return ExportMessageLink.super.grouped();
    }

    private boolean threadInitialize() {
        return ExportMessageLink.super.thread();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean grouped() {
        InitShim shim = this.initShim;
        return shim != null ? shim.grouped() : this.grouped;
    }

    @Override
    public boolean thread() {
        InitShim shim = this.initShim;
        return shim != null ? shim.thread() : this.thread;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public int id() {
        return this.id;
    }

    public final ImmutableExportMessageLink withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportMessageLink(value, this.flags, this.grouped, this.thread, this.channel, this.id);
    }

    public final ImmutableExportMessageLink withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableExportMessageLink(this.identifier, value, this.grouped, this.thread, this.channel, this.id);
    }

    public final ImmutableExportMessageLink withGrouped(boolean value) {
        if (this.grouped == value) {
            return this;
        }
        return new ImmutableExportMessageLink(this.identifier, this.flags, value, this.thread, this.channel, this.id);
    }

    public final ImmutableExportMessageLink withThread(boolean value) {
        if (this.thread == value) {
            return this;
        }
        return new ImmutableExportMessageLink(this.identifier, this.flags, this.grouped, value, this.channel, this.id);
    }

    public final ImmutableExportMessageLink withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableExportMessageLink(this.identifier, this.flags, this.grouped, this.thread, newValue, this.id);
    }

    public final ImmutableExportMessageLink withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableExportMessageLink(this.identifier, this.flags, this.grouped, this.thread, this.channel, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportMessageLink && this.equalTo(0, (ImmutableExportMessageLink)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportMessageLink another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.grouped == another.grouped && this.thread == another.thread && this.channel.equals(another.channel) && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.grouped);
        h += (h << 5) + Boolean.hashCode(this.thread);
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.id;
        return h;
    }

    public String toString() {
        return "ExportMessageLink{identifier=" + this.identifier + ", flags=" + this.flags + ", grouped=" + this.grouped + ", thread=" + this.thread + ", channel=" + this.channel + ", id=" + this.id + "}";
    }

    public static ImmutableExportMessageLink of(InputChannel channel, int id) {
        return new ImmutableExportMessageLink(channel, id);
    }

    public static ImmutableExportMessageLink copyOf(ExportMessageLink instance) {
        if (instance instanceof ImmutableExportMessageLink) {
            return (ImmutableExportMessageLink)instance;
        }
        return ImmutableExportMessageLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_GROUPED = 4L;
        private static final long OPT_BIT_THREAD = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean grouped;
        private boolean thread;
        private InputChannel channel;
        private int id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExportMessageLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ExportMessageLink) {
                instance = (ExportMessageLink)object;
                this.flags(instance.flags());
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.grouped(instance.grouped());
                this.thread(instance.thread());
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder grouped(boolean grouped) {
            this.grouped = grouped;
            this.optBits |= 4L;
            return this;
        }

        public final Builder thread(boolean thread) {
            this.thread = thread;
            this.optBits |= 8L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableExportMessageLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportMessageLink(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean groupedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean threadIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ExportMessageLink, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte groupedBuildStage = 0;
        private boolean grouped;
        private byte threadBuildStage = 0;
        private boolean thread;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableExportMessageLink.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableExportMessageLink.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean grouped() {
            if (this.groupedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupedBuildStage == 0) {
                this.groupedBuildStage = (byte)-1;
                this.grouped = ImmutableExportMessageLink.this.groupedInitialize();
                this.groupedBuildStage = 1;
            }
            return this.grouped;
        }

        void grouped(boolean grouped) {
            this.grouped = grouped;
            this.groupedBuildStage = 1;
        }

        boolean thread() {
            if (this.threadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.threadBuildStage == 0) {
                this.threadBuildStage = (byte)-1;
                this.thread = ImmutableExportMessageLink.this.threadInitialize();
                this.threadBuildStage = 1;
            }
            return this.thread;
        }

        void thread(boolean thread) {
            this.thread = thread;
            this.threadBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.groupedBuildStage == -1) {
                attributes.add("grouped");
            }
            if (this.threadBuildStage == -1) {
                attributes.add("thread");
            }
            return "Cannot build ExportMessageLink, attribute initializers form cycle " + attributes;
        }
    }
}

