/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChannelAdminLogEventsFilter;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.GetAdminLog;

public final class ImmutableGetAdminLog
implements GetAdminLog {
    private final int identifier;
    private final int flags;
    private final InputChannel channel;
    private final String q;
    @Nullable
    private final ChannelAdminLogEventsFilter eventsFilter;
    @Nullable
    private final List<InputUser> admins;
    private final long maxId;
    private final long minId;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetAdminLog(InputChannel channel, String q, long maxId, long minId, int limit) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.q = Objects.requireNonNull(q, "q");
        this.maxId = maxId;
        this.minId = minId;
        this.limit = limit;
        this.eventsFilter = null;
        this.admins = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetAdminLog(Builder builder) {
        this.channel = builder.channel;
        this.q = builder.q;
        this.eventsFilter = builder.eventsFilter;
        this.admins = builder.admins == null ? null : ImmutableGetAdminLog.createUnmodifiableList(true, builder.admins);
        this.maxId = builder.maxId;
        this.minId = builder.minId;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetAdminLog(int identifier, int flags, InputChannel channel, String q, @Nullable ChannelAdminLogEventsFilter eventsFilter, @Nullable List<InputUser> admins, long maxId, long minId, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.channel = channel;
        this.q = q;
        this.eventsFilter = eventsFilter;
        this.admins = admins;
        this.maxId = maxId;
        this.minId = minId;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetAdminLog.super.identifier();
    }

    private int flagsInitialize() {
        return GetAdminLog.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    @Nullable
    public ChannelAdminLogEventsFilter eventsFilter() {
        return this.eventsFilter;
    }

    @Override
    @Nullable
    public List<InputUser> admins() {
        return this.admins;
    }

    @Override
    public long maxId() {
        return this.maxId;
    }

    @Override
    public long minId() {
        return this.minId;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetAdminLog withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetAdminLog(value, this.flags, this.channel, this.q, this.eventsFilter, this.admins, this.maxId, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetAdminLog(this.identifier, value, this.channel, this.q, this.eventsFilter, this.admins, this.maxId, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableGetAdminLog(this.identifier, this.flags, newValue, this.q, this.eventsFilter, this.admins, this.maxId, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withQ(String value) {
        String newValue = Objects.requireNonNull(value, "q");
        if (this.q.equals(newValue)) {
            return this;
        }
        return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, newValue, this.eventsFilter, this.admins, this.maxId, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withEventsFilter(@Nullable ChannelAdminLogEventsFilter value) {
        if (this.eventsFilter == value) {
            return this;
        }
        return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, this.q, value, this.admins, this.maxId, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withAdmins(InputUser ... elements) {
        if (elements == null) {
            return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, this.q, this.eventsFilter, null, this.maxId, this.minId, this.limit);
        }
        List<InputUser> newValue = Arrays.asList(elements) == null ? null : ImmutableGetAdminLog.createUnmodifiableList(false, ImmutableGetAdminLog.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, this.q, this.eventsFilter, newValue, this.maxId, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withAdmins(@Nullable Iterable<? extends InputUser> elements) {
        if (this.admins == elements) {
            return this;
        }
        List<InputUser> newValue = elements == null ? null : ImmutableGetAdminLog.createUnmodifiableList(false, ImmutableGetAdminLog.createSafeList(elements, true, false));
        return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, this.q, this.eventsFilter, newValue, this.maxId, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withMaxId(long value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, this.q, this.eventsFilter, this.admins, value, this.minId, this.limit);
    }

    public final ImmutableGetAdminLog withMinId(long value) {
        if (this.minId == value) {
            return this;
        }
        return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, this.q, this.eventsFilter, this.admins, this.maxId, value, this.limit);
    }

    public final ImmutableGetAdminLog withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetAdminLog(this.identifier, this.flags, this.channel, this.q, this.eventsFilter, this.admins, this.maxId, this.minId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAdminLog && this.equalTo(0, (ImmutableGetAdminLog)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAdminLog another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.channel.equals(another.channel) && this.q.equals(another.q) && Objects.equals(this.eventsFilter, another.eventsFilter) && Objects.equals(this.admins, another.admins) && this.maxId == another.maxId && this.minId == another.minId && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.q.hashCode();
        h += (h << 5) + Objects.hashCode(this.eventsFilter);
        h += (h << 5) + Objects.hashCode(this.admins);
        h += (h << 5) + Long.hashCode(this.maxId);
        h += (h << 5) + Long.hashCode(this.minId);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetAdminLog{identifier=" + this.identifier + ", flags=" + this.flags + ", channel=" + this.channel + ", q=" + this.q + ", eventsFilter=" + this.eventsFilter + ", admins=" + this.admins + ", maxId=" + this.maxId + ", minId=" + this.minId + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetAdminLog of(InputChannel channel, String q, long maxId, long minId, int limit) {
        return new ImmutableGetAdminLog(channel, q, maxId, minId, limit);
    }

    public static ImmutableGetAdminLog copyOf(GetAdminLog instance) {
        if (instance instanceof ImmutableGetAdminLog) {
            return (ImmutableGetAdminLog)instance;
        }
        return ImmutableGetAdminLog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_Q = 2L;
        private static final long INIT_BIT_MAX_ID = 4L;
        private static final long INIT_BIT_MIN_ID = 8L;
        private static final long INIT_BIT_LIMIT = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputChannel channel;
        private String q;
        private ChannelAdminLogEventsFilter eventsFilter;
        private List<InputUser> admins = null;
        private long maxId;
        private long minId;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetAdminLog instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetAdminLog instance;
            long bits = 0L;
            if (object instanceof GetAdminLog) {
                instance = (GetAdminLog)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.q(instance.q());
                this.maxId(instance.maxId());
                ChannelAdminLogEventsFilter eventsFilterValue = instance.eventsFilter();
                if (eventsFilterValue != null) {
                    this.eventsFilter(eventsFilterValue);
                }
                this.flags(instance.flags());
                this.channel(instance.channel());
                this.limit(instance.limit());
                this.minId(instance.minId());
                List<InputUser> adminsValue = instance.admins();
                if (adminsValue != null) {
                    this.addAllAdmins(adminsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder q(String q) {
            this.q = Objects.requireNonNull(q, "q");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder eventsFilter(@Nullable ChannelAdminLogEventsFilter eventsFilter) {
            this.eventsFilter = eventsFilter;
            return this;
        }

        public final Builder addAdmin(InputUser element) {
            if (this.admins == null) {
                this.admins = new ArrayList<InputUser>();
            }
            this.admins.add(Objects.requireNonNull(element, "admins element"));
            return this;
        }

        public final Builder addAdmins(InputUser ... elements) {
            if (this.admins == null) {
                this.admins = new ArrayList<InputUser>();
            }
            for (InputUser element : elements) {
                this.admins.add(Objects.requireNonNull(element, "admins element"));
            }
            return this;
        }

        public final Builder admins(@Nullable Iterable<? extends InputUser> elements) {
            if (elements == null) {
                this.admins = null;
                return this;
            }
            this.admins = new ArrayList<InputUser>();
            return this.addAllAdmins(elements);
        }

        public final Builder addAllAdmins(Iterable<? extends InputUser> elements) {
            Objects.requireNonNull(elements, "admins element");
            if (this.admins == null) {
                this.admins = new ArrayList<InputUser>();
            }
            for (InputUser inputUser : elements) {
                this.admins.add(Objects.requireNonNull(inputUser, "admins element"));
            }
            return this;
        }

        public final Builder maxId(long maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder minId(long minId) {
            this.minId = minId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableGetAdminLog build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetAdminLog(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("q");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("minId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetAdminLog, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetAdminLog.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetAdminLog.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GetAdminLog, attribute initializers form cycle " + attributes;
        }
    }
}

