/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.GetAdminedPublicChannels;

public final class ImmutableGetAdminedPublicChannels
implements GetAdminedPublicChannels {
    private final int identifier;
    private final int flags;
    private final boolean byLocation;
    private final boolean checkLimit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableGetAdminedPublicChannels INSTANCE = ImmutableGetAdminedPublicChannels.validate(new ImmutableGetAdminedPublicChannels());

    private ImmutableGetAdminedPublicChannels() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.byLocation = this.initShim.byLocation();
        this.checkLimit = this.initShim.checkLimit();
        this.initShim = null;
    }

    private ImmutableGetAdminedPublicChannels(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.byLocationIsSet()) {
            this.initShim.byLocation(builder.byLocation);
        }
        if (builder.checkLimitIsSet()) {
            this.initShim.checkLimit(builder.checkLimit);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.byLocation = this.initShim.byLocation();
        this.checkLimit = this.initShim.checkLimit();
        this.initShim = null;
    }

    private ImmutableGetAdminedPublicChannels(int identifier, int flags, boolean byLocation, boolean checkLimit) {
        this.identifier = identifier;
        this.flags = flags;
        this.byLocation = byLocation;
        this.checkLimit = checkLimit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetAdminedPublicChannels.super.identifier();
    }

    private int flagsInitialize() {
        return GetAdminedPublicChannels.super.flags();
    }

    private boolean byLocationInitialize() {
        return GetAdminedPublicChannels.super.byLocation();
    }

    private boolean checkLimitInitialize() {
        return GetAdminedPublicChannels.super.checkLimit();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean byLocation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.byLocation() : this.byLocation;
    }

    @Override
    public boolean checkLimit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.checkLimit() : this.checkLimit;
    }

    public final ImmutableGetAdminedPublicChannels withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGetAdminedPublicChannels.validate(new ImmutableGetAdminedPublicChannels(value, this.flags, this.byLocation, this.checkLimit));
    }

    public final ImmutableGetAdminedPublicChannels withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableGetAdminedPublicChannels.validate(new ImmutableGetAdminedPublicChannels(this.identifier, value, this.byLocation, this.checkLimit));
    }

    public final ImmutableGetAdminedPublicChannels withByLocation(boolean value) {
        if (this.byLocation == value) {
            return this;
        }
        return ImmutableGetAdminedPublicChannels.validate(new ImmutableGetAdminedPublicChannels(this.identifier, this.flags, value, this.checkLimit));
    }

    public final ImmutableGetAdminedPublicChannels withCheckLimit(boolean value) {
        if (this.checkLimit == value) {
            return this;
        }
        return ImmutableGetAdminedPublicChannels.validate(new ImmutableGetAdminedPublicChannels(this.identifier, this.flags, this.byLocation, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAdminedPublicChannels && this.equalTo(0, (ImmutableGetAdminedPublicChannels)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAdminedPublicChannels another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.byLocation == another.byLocation && this.checkLimit == another.checkLimit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.byLocation);
        h += (h << 5) + Boolean.hashCode(this.checkLimit);
        return h;
    }

    public String toString() {
        return "GetAdminedPublicChannels{identifier=" + this.identifier + ", flags=" + this.flags + ", byLocation=" + this.byLocation + ", checkLimit=" + this.checkLimit + "}";
    }

    public static ImmutableGetAdminedPublicChannels of() {
        return INSTANCE;
    }

    private static ImmutableGetAdminedPublicChannels validate(ImmutableGetAdminedPublicChannels instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGetAdminedPublicChannels copyOf(GetAdminedPublicChannels instance) {
        if (instance instanceof ImmutableGetAdminedPublicChannels) {
            return (ImmutableGetAdminedPublicChannels)instance;
        }
        return ImmutableGetAdminedPublicChannels.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BY_LOCATION = 4L;
        private static final long OPT_BIT_CHECK_LIMIT = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean byLocation;
        private boolean checkLimit;

        private Builder() {
        }

        public final Builder from(GetAdminedPublicChannels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetAdminedPublicChannels instance;
            long bits = 0L;
            if (object instanceof GetAdminedPublicChannels) {
                instance = (GetAdminedPublicChannels)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.checkLimit(instance.checkLimit());
                this.byLocation(instance.byLocation());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder byLocation(boolean byLocation) {
            this.byLocation = byLocation;
            this.optBits |= 4L;
            return this;
        }

        public final Builder checkLimit(boolean checkLimit) {
            this.checkLimit = checkLimit;
            this.optBits |= 8L;
            return this;
        }

        public ImmutableGetAdminedPublicChannels build() {
            return ImmutableGetAdminedPublicChannels.validate(new ImmutableGetAdminedPublicChannels(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean byLocationIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean checkLimitIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte byLocationBuildStage = 0;
        private boolean byLocation;
        private byte checkLimitBuildStage = 0;
        private boolean checkLimit;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetAdminedPublicChannels.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetAdminedPublicChannels.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean byLocation() {
            if (this.byLocationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.byLocationBuildStage == 0) {
                this.byLocationBuildStage = (byte)-1;
                this.byLocation = ImmutableGetAdminedPublicChannels.this.byLocationInitialize();
                this.byLocationBuildStage = 1;
            }
            return this.byLocation;
        }

        void byLocation(boolean byLocation) {
            this.byLocation = byLocation;
            this.byLocationBuildStage = 1;
        }

        boolean checkLimit() {
            if (this.checkLimitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.checkLimitBuildStage == 0) {
                this.checkLimitBuildStage = (byte)-1;
                this.checkLimit = ImmutableGetAdminedPublicChannels.this.checkLimitInitialize();
                this.checkLimitBuildStage = 1;
            }
            return this.checkLimit;
        }

        void checkLimit(boolean checkLimit) {
            this.checkLimit = checkLimit;
            this.checkLimitBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.byLocationBuildStage == -1) {
                attributes.add("byLocation");
            }
            if (this.checkLimitBuildStage == -1) {
                attributes.add("checkLimit");
            }
            return "Cannot build GetAdminedPublicChannels, attribute initializers form cycle " + attributes;
        }
    }
}

