/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.GetFullChannel;

public final class ImmutableGetFullChannel
implements GetFullChannel {
    private final int identifier;
    private final InputChannel channel;

    private ImmutableGetFullChannel(InputChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.identifier = GetFullChannel.super.identifier();
    }

    private ImmutableGetFullChannel(Builder builder) {
        this.channel = builder.channel;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetFullChannel.super.identifier();
    }

    private ImmutableGetFullChannel(int identifier, InputChannel channel) {
        this.identifier = identifier;
        this.channel = channel;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    public final ImmutableGetFullChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetFullChannel(value, this.channel);
    }

    public final ImmutableGetFullChannel withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableGetFullChannel(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetFullChannel && this.equalTo(0, (ImmutableGetFullChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetFullChannel another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    public String toString() {
        return "GetFullChannel{identifier=" + this.identifier + ", channel=" + this.channel + "}";
    }

    public static ImmutableGetFullChannel of(InputChannel channel) {
        return new ImmutableGetFullChannel(channel);
    }

    public static ImmutableGetFullChannel copyOf(GetFullChannel instance) {
        if (instance instanceof ImmutableGetFullChannel) {
            return (ImmutableGetFullChannel)instance;
        }
        return ImmutableGetFullChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputChannel channel;

        private Builder() {
        }

        public final Builder from(GetFullChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetFullChannel instance;
            long bits = 0L;
            if (object instanceof GetFullChannel) {
                instance = (GetFullChannel)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetFullChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetFullChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            return "Cannot build GetFullChannel, some of required attributes are not set " + attributes;
        }
    }
}

