/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.GetLeftChannels;

public final class ImmutableGetLeftChannels
implements GetLeftChannels {
    private final int identifier;
    private final int offset;

    private ImmutableGetLeftChannels(int offset) {
        this.offset = offset;
        this.identifier = GetLeftChannels.super.identifier();
    }

    private ImmutableGetLeftChannels(Builder builder) {
        this.offset = builder.offset;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetLeftChannels.super.identifier();
    }

    private ImmutableGetLeftChannels(int identifier, int offset) {
        this.identifier = identifier;
        this.offset = offset;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    public final ImmutableGetLeftChannels withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetLeftChannels(value, this.offset);
    }

    public final ImmutableGetLeftChannels withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetLeftChannels(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetLeftChannels && this.equalTo(0, (ImmutableGetLeftChannels)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetLeftChannels another) {
        return this.identifier == another.identifier && this.offset == another.offset;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        return h;
    }

    public String toString() {
        return "GetLeftChannels{identifier=" + this.identifier + ", offset=" + this.offset + "}";
    }

    public static ImmutableGetLeftChannels of(int offset) {
        return new ImmutableGetLeftChannels(offset);
    }

    public static ImmutableGetLeftChannels copyOf(GetLeftChannels instance) {
        if (instance instanceof ImmutableGetLeftChannels) {
            return (ImmutableGetLeftChannels)instance;
        }
        return ImmutableGetLeftChannels.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int offset;

        private Builder() {
        }

        public final Builder from(GetLeftChannels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetLeftChannels instance;
            long bits = 0L;
            if (object instanceof GetLeftChannels) {
                instance = (GetLeftChannels)object;
                this.offset(instance.offset());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetLeftChannels build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetLeftChannels(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build GetLeftChannels, some of required attributes are not set " + attributes;
        }
    }
}

