/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.GetParticipant;

public final class ImmutableGetParticipant
implements GetParticipant {
    private final int identifier;
    private final InputChannel channel;
    private final InputPeer participant;

    private ImmutableGetParticipant(InputChannel channel, InputPeer participant) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.participant = Objects.requireNonNull(participant, "participant");
        this.identifier = GetParticipant.super.identifier();
    }

    private ImmutableGetParticipant(Builder builder) {
        this.channel = builder.channel;
        this.participant = builder.participant;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetParticipant.super.identifier();
    }

    private ImmutableGetParticipant(int identifier, InputChannel channel, InputPeer participant) {
        this.identifier = identifier;
        this.channel = channel;
        this.participant = participant;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputPeer participant() {
        return this.participant;
    }

    public final ImmutableGetParticipant withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetParticipant(value, this.channel, this.participant);
    }

    public final ImmutableGetParticipant withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableGetParticipant(this.identifier, newValue, this.participant);
    }

    public final ImmutableGetParticipant withParticipant(InputPeer value) {
        if (this.participant == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "participant");
        return new ImmutableGetParticipant(this.identifier, this.channel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetParticipant && this.equalTo(0, (ImmutableGetParticipant)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetParticipant another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.participant.equals(another.participant);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.participant.hashCode();
        return h;
    }

    public String toString() {
        return "GetParticipant{identifier=" + this.identifier + ", channel=" + this.channel + ", participant=" + this.participant + "}";
    }

    public static ImmutableGetParticipant of(InputChannel channel, InputPeer participant) {
        return new ImmutableGetParticipant(channel, participant);
    }

    public static ImmutableGetParticipant copyOf(GetParticipant instance) {
        if (instance instanceof ImmutableGetParticipant) {
            return (ImmutableGetParticipant)instance;
        }
        return ImmutableGetParticipant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_PARTICIPANT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputPeer participant;

        private Builder() {
        }

        public final Builder from(GetParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetParticipant instance;
            long bits = 0L;
            if (object instanceof GetParticipant) {
                instance = (GetParticipant)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.participant(instance.participant());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder participant(InputPeer participant) {
            this.participant = Objects.requireNonNull(participant, "participant");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetParticipant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetParticipant(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("participant");
            }
            return "Cannot build GetParticipant, some of required attributes are not set " + attributes;
        }
    }
}

