/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelParticipantsFilter;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.GetParticipants;

public final class ImmutableGetParticipants
implements GetParticipants {
    private final int identifier;
    private final InputChannel channel;
    private final ChannelParticipantsFilter filter;
    private final int offset;
    private final int limit;
    private final long hash;

    private ImmutableGetParticipants(InputChannel channel, ChannelParticipantsFilter filter, int offset, int limit, long hash) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.filter = Objects.requireNonNull(filter, "filter");
        this.offset = offset;
        this.limit = limit;
        this.hash = hash;
        this.identifier = GetParticipants.super.identifier();
    }

    private ImmutableGetParticipants(Builder builder) {
        this.channel = builder.channel;
        this.filter = builder.filter;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetParticipants.super.identifier();
    }

    private ImmutableGetParticipants(int identifier, InputChannel channel, ChannelParticipantsFilter filter, int offset, int limit, long hash) {
        this.identifier = identifier;
        this.channel = channel;
        this.filter = filter;
        this.offset = offset;
        this.limit = limit;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public ChannelParticipantsFilter filter() {
        return this.filter;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetParticipants(value, this.channel, this.filter, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetParticipants withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableGetParticipants(this.identifier, newValue, this.filter, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetParticipants withFilter(ChannelParticipantsFilter value) {
        if (this.filter == value) {
            return this;
        }
        ChannelParticipantsFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableGetParticipants(this.identifier, this.channel, newValue, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetParticipants withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetParticipants(this.identifier, this.channel, this.filter, value, this.limit, this.hash);
    }

    public final ImmutableGetParticipants withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetParticipants(this.identifier, this.channel, this.filter, this.offset, value, this.hash);
    }

    public final ImmutableGetParticipants withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetParticipants(this.identifier, this.channel, this.filter, this.offset, this.limit, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetParticipants && this.equalTo(0, (ImmutableGetParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetParticipants another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.filter.equals(another.filter) && this.offset == another.offset && this.limit == another.limit && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.offset;
        h += (h << 5) + this.limit;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetParticipants{identifier=" + this.identifier + ", channel=" + this.channel + ", filter=" + this.filter + ", offset=" + this.offset + ", limit=" + this.limit + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetParticipants of(InputChannel channel, ChannelParticipantsFilter filter, int offset, int limit, long hash) {
        return new ImmutableGetParticipants(channel, filter, offset, limit, hash);
    }

    public static ImmutableGetParticipants copyOf(GetParticipants instance) {
        if (instance instanceof ImmutableGetParticipants) {
            return (ImmutableGetParticipants)instance;
        }
        return ImmutableGetParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_FILTER = 2L;
        private static final long INIT_BIT_OFFSET = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long INIT_BIT_HASH = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private ChannelParticipantsFilter filter;
        private int offset;
        private int limit;
        private long hash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetParticipants) {
                instance = (GetParticipants)object;
                this.filter(instance.filter());
                this.channel(instance.channel());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filter(ChannelParticipantsFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableGetParticipants build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetParticipants, some of required attributes are not set " + attributes;
        }
    }
}

