/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.InviteToChannel;

public final class ImmutableInviteToChannel
implements InviteToChannel {
    private final int identifier;
    private final InputChannel channel;
    private final List<InputUser> users;

    private ImmutableInviteToChannel(InputChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.users = Collections.emptyList();
        this.identifier = InviteToChannel.super.identifier();
    }

    private ImmutableInviteToChannel(Builder builder) {
        this.channel = builder.channel;
        this.users = ImmutableInviteToChannel.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : InviteToChannel.super.identifier();
    }

    private ImmutableInviteToChannel(int identifier, InputChannel channel, List<InputUser> users) {
        this.identifier = identifier;
        this.channel = channel;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public List<InputUser> users() {
        return this.users;
    }

    public final ImmutableInviteToChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInviteToChannel(value, this.channel, this.users);
    }

    public final ImmutableInviteToChannel withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableInviteToChannel(this.identifier, newValue, this.users);
    }

    public final ImmutableInviteToChannel withUsers(InputUser ... elements) {
        List<InputUser> newValue = ImmutableInviteToChannel.createUnmodifiableList(false, ImmutableInviteToChannel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInviteToChannel(this.identifier, this.channel, newValue);
    }

    public final ImmutableInviteToChannel withUsers(Iterable<? extends InputUser> elements) {
        if (this.users == elements) {
            return this;
        }
        List<InputUser> newValue = ImmutableInviteToChannel.createUnmodifiableList(false, ImmutableInviteToChannel.createSafeList(elements, true, false));
        return new ImmutableInviteToChannel(this.identifier, this.channel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInviteToChannel && this.equalTo(0, (ImmutableInviteToChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableInviteToChannel another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "InviteToChannel{identifier=" + this.identifier + ", channel=" + this.channel + ", users=" + this.users + "}";
    }

    public static ImmutableInviteToChannel of(InputChannel channel) {
        return new ImmutableInviteToChannel(channel);
    }

    public static ImmutableInviteToChannel copyOf(InviteToChannel instance) {
        if (instance instanceof ImmutableInviteToChannel) {
            return (ImmutableInviteToChannel)instance;
        }
        return ImmutableInviteToChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private List<InputUser> users = new ArrayList<InputUser>();

        private Builder() {
        }

        public final Builder from(InviteToChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InviteToChannel instance;
            long bits = 0L;
            if (object instanceof InviteToChannel) {
                instance = (InviteToChannel)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(InputUser element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(InputUser ... elements) {
            for (InputUser element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends InputUser> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends InputUser> elements) {
            for (InputUser inputUser : elements) {
                this.users.add(Objects.requireNonNull(inputUser, "users element"));
            }
            return this;
        }

        public ImmutableInviteToChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInviteToChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            return "Cannot build InviteToChannel, some of required attributes are not set " + attributes;
        }
    }
}

