/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.ReadHistory;

public final class ImmutableReadHistory
implements ReadHistory {
    private final int identifier;
    private final InputChannel channel;
    private final int maxId;

    private ImmutableReadHistory(InputChannel channel, int maxId) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.maxId = maxId;
        this.identifier = ReadHistory.super.identifier();
    }

    private ImmutableReadHistory(Builder builder) {
        this.channel = builder.channel;
        this.maxId = builder.maxId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReadHistory.super.identifier();
    }

    private ImmutableReadHistory(int identifier, InputChannel channel, int maxId) {
        this.identifier = identifier;
        this.channel = channel;
        this.maxId = maxId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    public final ImmutableReadHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReadHistory(value, this.channel, this.maxId);
    }

    public final ImmutableReadHistory withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableReadHistory(this.identifier, newValue, this.maxId);
    }

    public final ImmutableReadHistory withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableReadHistory(this.identifier, this.channel, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadHistory && this.equalTo(0, (ImmutableReadHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadHistory another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.maxId == another.maxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.maxId;
        return h;
    }

    public String toString() {
        return "ReadHistory{identifier=" + this.identifier + ", channel=" + this.channel + ", maxId=" + this.maxId + "}";
    }

    public static ImmutableReadHistory of(InputChannel channel, int maxId) {
        return new ImmutableReadHistory(channel, maxId);
    }

    public static ImmutableReadHistory copyOf(ReadHistory instance) {
        if (instance instanceof ImmutableReadHistory) {
            return (ImmutableReadHistory)instance;
        }
        return ImmutableReadHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private int maxId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReadHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ReadHistory) {
                instance = (ReadHistory)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReadHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            return "Cannot build ReadHistory, some of required attributes are not set " + attributes;
        }
    }
}

