/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.ReadMessageContents;

public final class ImmutableReadMessageContents
implements ReadMessageContents {
    private final int identifier;
    private final InputChannel channel;
    private final List<Integer> id;

    private ImmutableReadMessageContents(InputChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.id = Collections.emptyList();
        this.identifier = ReadMessageContents.super.identifier();
    }

    private ImmutableReadMessageContents(Builder builder) {
        this.channel = builder.channel;
        this.id = ImmutableReadMessageContents.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReadMessageContents.super.identifier();
    }

    private ImmutableReadMessageContents(int identifier, InputChannel channel, List<Integer> id) {
        this.identifier = identifier;
        this.channel = channel;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public List<Integer> id() {
        return this.id;
    }

    public final ImmutableReadMessageContents withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReadMessageContents(value, this.channel, this.id);
    }

    public final ImmutableReadMessageContents withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableReadMessageContents(this.identifier, newValue, this.id);
    }

    public final ImmutableReadMessageContents withId(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableReadMessageContents.createUnmodifiableList(false, wrappedList);
        return new ImmutableReadMessageContents(this.identifier, this.channel, newValue);
    }

    public final ImmutableReadMessageContents withId(Iterable<Integer> elements) {
        if (this.id == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableReadMessageContents.createUnmodifiableList(false, ImmutableReadMessageContents.createSafeList(elements, true, false));
        return new ImmutableReadMessageContents(this.identifier, this.channel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadMessageContents && this.equalTo(0, (ImmutableReadMessageContents)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadMessageContents another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "ReadMessageContents{identifier=" + this.identifier + ", channel=" + this.channel + ", id=" + this.id + "}";
    }

    public static ImmutableReadMessageContents of(InputChannel channel) {
        return new ImmutableReadMessageContents(channel);
    }

    public static ImmutableReadMessageContents copyOf(ReadMessageContents instance) {
        if (instance instanceof ImmutableReadMessageContents) {
            return (ImmutableReadMessageContents)instance;
        }
        return ImmutableReadMessageContents.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private List<Integer> id = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(ReadMessageContents instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReadMessageContents instance;
            long bits = 0L;
            if (object instanceof ReadMessageContents) {
                instance = (ReadMessageContents)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllId(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addId(int element) {
            this.id.add(element);
            return this;
        }

        public final Builder addId(int ... elements) {
            for (int element : elements) {
                this.id.add(element);
            }
            return this;
        }

        public final Builder id(Iterable<Integer> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public ImmutableReadMessageContents build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadMessageContents(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            return "Cannot build ReadMessageContents, some of required attributes are not set " + attributes;
        }
    }
}

