/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.ReportSpam;

public final class ImmutableReportSpam
implements ReportSpam {
    private final int identifier;
    private final InputChannel channel;
    private final InputPeer participant;
    private final List<Integer> id;

    private ImmutableReportSpam(InputChannel channel, InputPeer participant) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.participant = Objects.requireNonNull(participant, "participant");
        this.id = Collections.emptyList();
        this.identifier = ReportSpam.super.identifier();
    }

    private ImmutableReportSpam(Builder builder) {
        this.channel = builder.channel;
        this.participant = builder.participant;
        this.id = ImmutableReportSpam.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReportSpam.super.identifier();
    }

    private ImmutableReportSpam(int identifier, InputChannel channel, InputPeer participant, List<Integer> id) {
        this.identifier = identifier;
        this.channel = channel;
        this.participant = participant;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputPeer participant() {
        return this.participant;
    }

    @Override
    public List<Integer> id() {
        return this.id;
    }

    public final ImmutableReportSpam withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReportSpam(value, this.channel, this.participant, this.id);
    }

    public final ImmutableReportSpam withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableReportSpam(this.identifier, newValue, this.participant, this.id);
    }

    public final ImmutableReportSpam withParticipant(InputPeer value) {
        if (this.participant == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "participant");
        return new ImmutableReportSpam(this.identifier, this.channel, newValue, this.id);
    }

    public final ImmutableReportSpam withId(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableReportSpam.createUnmodifiableList(false, wrappedList);
        return new ImmutableReportSpam(this.identifier, this.channel, this.participant, newValue);
    }

    public final ImmutableReportSpam withId(Iterable<Integer> elements) {
        if (this.id == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableReportSpam.createUnmodifiableList(false, ImmutableReportSpam.createSafeList(elements, true, false));
        return new ImmutableReportSpam(this.identifier, this.channel, this.participant, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportSpam && this.equalTo(0, (ImmutableReportSpam)another);
    }

    private boolean equalTo(int synthetic, ImmutableReportSpam another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.participant.equals(another.participant) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.participant.hashCode();
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "ReportSpam{identifier=" + this.identifier + ", channel=" + this.channel + ", participant=" + this.participant + ", id=" + this.id + "}";
    }

    public static ImmutableReportSpam of(InputChannel channel, InputPeer participant) {
        return new ImmutableReportSpam(channel, participant);
    }

    public static ImmutableReportSpam copyOf(ReportSpam instance) {
        if (instance instanceof ImmutableReportSpam) {
            return (ImmutableReportSpam)instance;
        }
        return ImmutableReportSpam.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_PARTICIPANT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputPeer participant;
        private List<Integer> id = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(ReportSpam instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReportSpam instance;
            long bits = 0L;
            if (object instanceof ReportSpam) {
                instance = (ReportSpam)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllId(instance.id());
                this.participant(instance.participant());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder participant(InputPeer participant) {
            this.participant = Objects.requireNonNull(participant, "participant");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addId(int element) {
            this.id.add(element);
            return this;
        }

        public final Builder addId(int ... elements) {
            for (int element : elements) {
                this.id.add(element);
            }
            return this;
        }

        public final Builder id(Iterable<Integer> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public ImmutableReportSpam build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReportSpam(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("participant");
            }
            return "Cannot build ReportSpam, some of required attributes are not set " + attributes;
        }
    }
}

