/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.SetDiscussionGroup;

public final class ImmutableSetDiscussionGroup
implements SetDiscussionGroup {
    private final int identifier;
    private final InputChannel broadcast;
    private final InputChannel group;

    private ImmutableSetDiscussionGroup(InputChannel broadcast, InputChannel group) {
        this.broadcast = Objects.requireNonNull(broadcast, "broadcast");
        this.group = Objects.requireNonNull(group, "group");
        this.identifier = SetDiscussionGroup.super.identifier();
    }

    private ImmutableSetDiscussionGroup(Builder builder) {
        this.broadcast = builder.broadcast;
        this.group = builder.group;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetDiscussionGroup.super.identifier();
    }

    private ImmutableSetDiscussionGroup(int identifier, InputChannel broadcast, InputChannel group) {
        this.identifier = identifier;
        this.broadcast = broadcast;
        this.group = group;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel broadcast() {
        return this.broadcast;
    }

    @Override
    public InputChannel group() {
        return this.group;
    }

    public final ImmutableSetDiscussionGroup withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetDiscussionGroup(value, this.broadcast, this.group);
    }

    public final ImmutableSetDiscussionGroup withBroadcast(InputChannel value) {
        if (this.broadcast == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "broadcast");
        return new ImmutableSetDiscussionGroup(this.identifier, newValue, this.group);
    }

    public final ImmutableSetDiscussionGroup withGroup(InputChannel value) {
        if (this.group == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "group");
        return new ImmutableSetDiscussionGroup(this.identifier, this.broadcast, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetDiscussionGroup && this.equalTo(0, (ImmutableSetDiscussionGroup)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetDiscussionGroup another) {
        return this.identifier == another.identifier && this.broadcast.equals(another.broadcast) && this.group.equals(another.group);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.broadcast.hashCode();
        h += (h << 5) + this.group.hashCode();
        return h;
    }

    public String toString() {
        return "SetDiscussionGroup{identifier=" + this.identifier + ", broadcast=" + this.broadcast + ", group=" + this.group + "}";
    }

    public static ImmutableSetDiscussionGroup of(InputChannel broadcast, InputChannel group) {
        return new ImmutableSetDiscussionGroup(broadcast, group);
    }

    public static ImmutableSetDiscussionGroup copyOf(SetDiscussionGroup instance) {
        if (instance instanceof ImmutableSetDiscussionGroup) {
            return (ImmutableSetDiscussionGroup)instance;
        }
        return ImmutableSetDiscussionGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BROADCAST = 1L;
        private static final long INIT_BIT_GROUP = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel broadcast;
        private InputChannel group;

        private Builder() {
        }

        public final Builder from(SetDiscussionGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetDiscussionGroup instance;
            long bits = 0L;
            if (object instanceof SetDiscussionGroup) {
                instance = (SetDiscussionGroup)object;
                this.broadcast(instance.broadcast());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.group(instance.group());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder broadcast(InputChannel broadcast) {
            this.broadcast = Objects.requireNonNull(broadcast, "broadcast");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder group(InputChannel group) {
            this.group = Objects.requireNonNull(group, "group");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetDiscussionGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetDiscussionGroup(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("broadcast");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("group");
            }
            return "Cannot build SetDiscussionGroup, some of required attributes are not set " + attributes;
        }
    }
}

