/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.SetStickers;

public final class ImmutableSetStickers
implements SetStickers {
    private final int identifier;
    private final InputChannel channel;
    private final InputStickerSet stickerset;

    private ImmutableSetStickers(InputChannel channel, InputStickerSet stickerset) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.identifier = SetStickers.super.identifier();
    }

    private ImmutableSetStickers(Builder builder) {
        this.channel = builder.channel;
        this.stickerset = builder.stickerset;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetStickers.super.identifier();
    }

    private ImmutableSetStickers(int identifier, InputChannel channel, InputStickerSet stickerset) {
        this.identifier = identifier;
        this.channel = channel;
        this.stickerset = stickerset;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    public final ImmutableSetStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetStickers(value, this.channel, this.stickerset);
    }

    public final ImmutableSetStickers withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableSetStickers(this.identifier, newValue, this.stickerset);
    }

    public final ImmutableSetStickers withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableSetStickers(this.identifier, this.channel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetStickers && this.equalTo(0, (ImmutableSetStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetStickers another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.stickerset.equals(another.stickerset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.stickerset.hashCode();
        return h;
    }

    public String toString() {
        return "SetStickers{identifier=" + this.identifier + ", channel=" + this.channel + ", stickerset=" + this.stickerset + "}";
    }

    public static ImmutableSetStickers of(InputChannel channel, InputStickerSet stickerset) {
        return new ImmutableSetStickers(channel, stickerset);
    }

    public static ImmutableSetStickers copyOf(SetStickers instance) {
        if (instance instanceof ImmutableSetStickers) {
            return (ImmutableSetStickers)instance;
        }
        return ImmutableSetStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_STICKERSET = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private InputStickerSet stickerset;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetStickers) {
                instance = (SetStickers)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stickerset");
            }
            return "Cannot build SetStickers, some of required attributes are not set " + attributes;
        }
    }
}

