/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.ToggleSignatures;

public final class ImmutableToggleSignatures
implements ToggleSignatures {
    private final int identifier;
    private final InputChannel channel;
    private final boolean enabled;

    private ImmutableToggleSignatures(InputChannel channel, boolean enabled) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.enabled = enabled;
        this.identifier = ToggleSignatures.super.identifier();
    }

    private ImmutableToggleSignatures(Builder builder) {
        this.channel = builder.channel;
        this.enabled = builder.enabled;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ToggleSignatures.super.identifier();
    }

    private ImmutableToggleSignatures(int identifier, InputChannel channel, boolean enabled) {
        this.identifier = identifier;
        this.channel = channel;
        this.enabled = enabled;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    public final ImmutableToggleSignatures withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleSignatures(value, this.channel, this.enabled);
    }

    public final ImmutableToggleSignatures withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableToggleSignatures(this.identifier, newValue, this.enabled);
    }

    public final ImmutableToggleSignatures withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableToggleSignatures(this.identifier, this.channel, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleSignatures && this.equalTo(0, (ImmutableToggleSignatures)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleSignatures another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.enabled == another.enabled;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + Boolean.hashCode(this.enabled);
        return h;
    }

    public String toString() {
        return "ToggleSignatures{identifier=" + this.identifier + ", channel=" + this.channel + ", enabled=" + this.enabled + "}";
    }

    public static ImmutableToggleSignatures of(InputChannel channel, boolean enabled) {
        return new ImmutableToggleSignatures(channel, enabled);
    }

    public static ImmutableToggleSignatures copyOf(ToggleSignatures instance) {
        if (instance instanceof ImmutableToggleSignatures) {
            return (ImmutableToggleSignatures)instance;
        }
        return ImmutableToggleSignatures.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_ENABLED = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private boolean enabled;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToggleSignatures instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ToggleSignatures) {
                instance = (ToggleSignatures)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.enabled(instance.enabled());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableToggleSignatures build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleSignatures(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build ToggleSignatures, some of required attributes are not set " + attributes;
        }
    }
}

