/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.ToggleSlowMode;

public final class ImmutableToggleSlowMode
implements ToggleSlowMode {
    private final int identifier;
    private final InputChannel channel;
    private final int seconds;

    private ImmutableToggleSlowMode(InputChannel channel, int seconds) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.seconds = seconds;
        this.identifier = ToggleSlowMode.super.identifier();
    }

    private ImmutableToggleSlowMode(Builder builder) {
        this.channel = builder.channel;
        this.seconds = builder.seconds;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ToggleSlowMode.super.identifier();
    }

    private ImmutableToggleSlowMode(int identifier, InputChannel channel, int seconds) {
        this.identifier = identifier;
        this.channel = channel;
        this.seconds = seconds;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public int seconds() {
        return this.seconds;
    }

    public final ImmutableToggleSlowMode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleSlowMode(value, this.channel, this.seconds);
    }

    public final ImmutableToggleSlowMode withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableToggleSlowMode(this.identifier, newValue, this.seconds);
    }

    public final ImmutableToggleSlowMode withSeconds(int value) {
        if (this.seconds == value) {
            return this;
        }
        return new ImmutableToggleSlowMode(this.identifier, this.channel, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleSlowMode && this.equalTo(0, (ImmutableToggleSlowMode)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleSlowMode another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.seconds == another.seconds;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.seconds;
        return h;
    }

    public String toString() {
        return "ToggleSlowMode{identifier=" + this.identifier + ", channel=" + this.channel + ", seconds=" + this.seconds + "}";
    }

    public static ImmutableToggleSlowMode of(InputChannel channel, int seconds) {
        return new ImmutableToggleSlowMode(channel, seconds);
    }

    public static ImmutableToggleSlowMode copyOf(ToggleSlowMode instance) {
        if (instance instanceof ImmutableToggleSlowMode) {
            return (ImmutableToggleSlowMode)instance;
        }
        return ImmutableToggleSlowMode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_SECONDS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputChannel channel;
        private int seconds;

        private Builder() {
        }

        public final Builder from(ToggleSlowMode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToggleSlowMode instance;
            long bits = 0L;
            if (object instanceof ToggleSlowMode) {
                instance = (ToggleSlowMode)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.seconds(instance.seconds());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder seconds(int seconds) {
            this.seconds = seconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableToggleSlowMode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleSlowMode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seconds");
            }
            return "Cannot build ToggleSlowMode, some of required attributes are not set " + attributes;
        }
    }
}

