/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.channels;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChannel;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.channels.ViewSponsoredMessage;

public final class ImmutableViewSponsoredMessage
implements ViewSponsoredMessage {
    private final int identifier;
    private final InputChannel channel;
    private final ByteBuf randomId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableViewSponsoredMessage(InputChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.randomId = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableViewSponsoredMessage(Builder builder) {
        this.channel = builder.channel;
        this.randomId = builder.randomId_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableViewSponsoredMessage(int identifier, InputChannel channel, ByteBuf randomId) {
        this.identifier = identifier;
        this.channel = channel;
        this.randomId = randomId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ViewSponsoredMessage.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputChannel channel() {
        return this.channel;
    }

    @Override
    public ByteBuf randomId() {
        return this.randomId.duplicate();
    }

    public final ImmutableViewSponsoredMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableViewSponsoredMessage(value, this.channel, this.randomId);
    }

    public final ImmutableViewSponsoredMessage withChannel(InputChannel value) {
        if (this.channel == value) {
            return this;
        }
        InputChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableViewSponsoredMessage(this.identifier, newValue, this.randomId);
    }

    public ImmutableViewSponsoredMessage withRandomId(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.randomId == newValue) {
            return this;
        }
        return new ImmutableViewSponsoredMessage(this.identifier, this.channel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableViewSponsoredMessage && this.equalTo(0, (ImmutableViewSponsoredMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableViewSponsoredMessage another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel) && this.randomId().equals((Object)another.randomId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.randomId().hashCode();
        return h;
    }

    public String toString() {
        return "ViewSponsoredMessage{identifier=" + this.identifier + ", channel=" + this.channel + ", randomId=" + ByteBufUtil.hexDump((ByteBuf)this.randomId) + "}";
    }

    public static ImmutableViewSponsoredMessage of(InputChannel channel) {
        return new ImmutableViewSponsoredMessage(channel);
    }

    public static ImmutableViewSponsoredMessage copyOf(ViewSponsoredMessage instance) {
        if (instance instanceof ImmutableViewSponsoredMessage) {
            return (ImmutableViewSponsoredMessage)instance;
        }
        return ImmutableViewSponsoredMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf randomId_value = null;
        private int identifier;
        private InputChannel channel;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewSponsoredMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewSponsoredMessage) {
                instance = (ViewSponsoredMessage)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(InputChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder randomId(ByteBuf value) {
            this.randomId_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableViewSponsoredMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableViewSponsoredMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            return "Cannot build ViewSponsoredMessage, some of required attributes are not set " + attributes;
        }

        private ByteBuf randomId_build() {
            return Objects.requireNonNull(this.randomId_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableViewSponsoredMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ViewSponsoredMessage, attribute initializers form cycle " + attributes;
        }
    }
}

