/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.AcceptContact;

public final class ImmutableAcceptContact
implements AcceptContact {
    private final int identifier;
    private final InputUser id;

    private ImmutableAcceptContact(InputUser id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = AcceptContact.super.identifier();
    }

    private ImmutableAcceptContact(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AcceptContact.super.identifier();
    }

    private ImmutableAcceptContact(int identifier, InputUser id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser id() {
        return this.id;
    }

    public final ImmutableAcceptContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAcceptContact(value, this.id);
    }

    public final ImmutableAcceptContact withId(InputUser value) {
        if (this.id == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "id");
        return new ImmutableAcceptContact(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptContact && this.equalTo(0, (ImmutableAcceptContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableAcceptContact another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "AcceptContact{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableAcceptContact of(InputUser id) {
        return new ImmutableAcceptContact(id);
    }

    public static ImmutableAcceptContact copyOf(AcceptContact instance) {
        if (instance instanceof ImmutableAcceptContact) {
            return (ImmutableAcceptContact)instance;
        }
        return ImmutableAcceptContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputUser id;

        private Builder() {
        }

        public final Builder from(AcceptContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AcceptContact instance;
            long bits = 0L;
            if (object instanceof AcceptContact) {
                instance = (AcceptContact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputUser id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableAcceptContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAcceptContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build AcceptContact, some of required attributes are not set " + attributes;
        }
    }
}

