/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.AddContact;

public final class ImmutableAddContact
implements AddContact {
    private final int identifier;
    private final int flags;
    private final boolean addPhonePrivacyException;
    private final InputUser id;
    private final String firstName;
    private final String lastName;
    private final String phone;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAddContact(InputUser id, String firstName, String lastName, String phone) {
        this.id = Objects.requireNonNull(id, "id");
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.phone = Objects.requireNonNull(phone, "phone");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.addPhonePrivacyException = this.initShim.addPhonePrivacyException();
        this.initShim = null;
    }

    private ImmutableAddContact(Builder builder) {
        this.id = builder.id;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phone = builder.phone;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.addPhonePrivacyExceptionIsSet()) {
            this.initShim.addPhonePrivacyException(builder.addPhonePrivacyException);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.addPhonePrivacyException = this.initShim.addPhonePrivacyException();
        this.initShim = null;
    }

    private ImmutableAddContact(int identifier, int flags, boolean addPhonePrivacyException, InputUser id, String firstName, String lastName, String phone) {
        this.identifier = identifier;
        this.flags = flags;
        this.addPhonePrivacyException = addPhonePrivacyException;
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.phone = phone;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AddContact.super.identifier();
    }

    private int flagsInitialize() {
        return AddContact.super.flags();
    }

    private boolean addPhonePrivacyExceptionInitialize() {
        return AddContact.super.addPhonePrivacyException();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean addPhonePrivacyException() {
        InitShim shim = this.initShim;
        return shim != null ? shim.addPhonePrivacyException() : this.addPhonePrivacyException;
    }

    @Override
    public InputUser id() {
        return this.id;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    public final ImmutableAddContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAddContact(value, this.flags, this.addPhonePrivacyException, this.id, this.firstName, this.lastName, this.phone);
    }

    public final ImmutableAddContact withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableAddContact(this.identifier, value, this.addPhonePrivacyException, this.id, this.firstName, this.lastName, this.phone);
    }

    public final ImmutableAddContact withAddPhonePrivacyException(boolean value) {
        if (this.addPhonePrivacyException == value) {
            return this;
        }
        return new ImmutableAddContact(this.identifier, this.flags, value, this.id, this.firstName, this.lastName, this.phone);
    }

    public final ImmutableAddContact withId(InputUser value) {
        if (this.id == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "id");
        return new ImmutableAddContact(this.identifier, this.flags, this.addPhonePrivacyException, newValue, this.firstName, this.lastName, this.phone);
    }

    public final ImmutableAddContact withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableAddContact(this.identifier, this.flags, this.addPhonePrivacyException, this.id, newValue, this.lastName, this.phone);
    }

    public final ImmutableAddContact withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableAddContact(this.identifier, this.flags, this.addPhonePrivacyException, this.id, this.firstName, newValue, this.phone);
    }

    public final ImmutableAddContact withPhone(String value) {
        String newValue = Objects.requireNonNull(value, "phone");
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableAddContact(this.identifier, this.flags, this.addPhonePrivacyException, this.id, this.firstName, this.lastName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAddContact && this.equalTo(0, (ImmutableAddContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableAddContact another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.addPhonePrivacyException == another.addPhonePrivacyException && this.id.equals(another.id) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName) && this.phone.equals(another.phone);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.addPhonePrivacyException);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        h += (h << 5) + this.phone.hashCode();
        return h;
    }

    public String toString() {
        return "AddContact{identifier=" + this.identifier + ", flags=" + this.flags + ", addPhonePrivacyException=" + this.addPhonePrivacyException + ", id=" + this.id + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", phone=" + this.phone + "}";
    }

    public static ImmutableAddContact of(InputUser id, String firstName, String lastName, String phone) {
        return new ImmutableAddContact(id, firstName, lastName, phone);
    }

    public static ImmutableAddContact copyOf(AddContact instance) {
        if (instance instanceof ImmutableAddContact) {
            return (ImmutableAddContact)instance;
        }
        return ImmutableAddContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_FIRST_NAME = 2L;
        private static final long INIT_BIT_LAST_NAME = 4L;
        private static final long INIT_BIT_PHONE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ADD_PHONE_PRIVACY_EXCEPTION = 4L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean addPhonePrivacyException;
        private InputUser id;
        private String firstName;
        private String lastName;
        private String phone;

        private Builder() {
        }

        public final Builder from(AddContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AddContact instance;
            long bits = 0L;
            if (object instanceof AddContact) {
                instance = (AddContact)object;
                this.addPhonePrivacyException(instance.addPhonePrivacyException());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.phone(instance.phone());
                this.flags(instance.flags());
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder addPhonePrivacyException(boolean addPhonePrivacyException) {
            this.addPhonePrivacyException = addPhonePrivacyException;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(InputUser id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder phone(String phone) {
            this.phone = Objects.requireNonNull(phone, "phone");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAddContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAddContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean addPhonePrivacyExceptionIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("phone");
            }
            return "Cannot build AddContact, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte addPhonePrivacyExceptionBuildStage = 0;
        private boolean addPhonePrivacyException;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAddContact.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAddContact.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean addPhonePrivacyException() {
            if (this.addPhonePrivacyExceptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.addPhonePrivacyExceptionBuildStage == 0) {
                this.addPhonePrivacyExceptionBuildStage = (byte)-1;
                this.addPhonePrivacyException = ImmutableAddContact.this.addPhonePrivacyExceptionInitialize();
                this.addPhonePrivacyExceptionBuildStage = 1;
            }
            return this.addPhonePrivacyException;
        }

        void addPhonePrivacyException(boolean addPhonePrivacyException) {
            this.addPhonePrivacyException = addPhonePrivacyException;
            this.addPhonePrivacyExceptionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.addPhonePrivacyExceptionBuildStage == -1) {
                attributes.add("addPhonePrivacyException");
            }
            return "Cannot build AddContact, attribute initializers form cycle " + attributes;
        }
    }
}

