/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.BlockFromReplies;

public final class ImmutableBlockFromReplies
implements BlockFromReplies {
    private final int identifier;
    private final int flags;
    private final boolean deleteMessage;
    private final boolean deleteHistory;
    private final boolean reportSpam;
    private final int msgId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBlockFromReplies(int msgId) {
        this.msgId = msgId;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.deleteMessage = this.initShim.deleteMessage();
        this.deleteHistory = this.initShim.deleteHistory();
        this.reportSpam = this.initShim.reportSpam();
        this.initShim = null;
    }

    private ImmutableBlockFromReplies(Builder builder) {
        this.msgId = builder.msgId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.deleteMessageIsSet()) {
            this.initShim.deleteMessage(builder.deleteMessage);
        }
        if (builder.deleteHistoryIsSet()) {
            this.initShim.deleteHistory(builder.deleteHistory);
        }
        if (builder.reportSpamIsSet()) {
            this.initShim.reportSpam(builder.reportSpam);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.deleteMessage = this.initShim.deleteMessage();
        this.deleteHistory = this.initShim.deleteHistory();
        this.reportSpam = this.initShim.reportSpam();
        this.initShim = null;
    }

    private ImmutableBlockFromReplies(int identifier, int flags, boolean deleteMessage, boolean deleteHistory, boolean reportSpam, int msgId) {
        this.identifier = identifier;
        this.flags = flags;
        this.deleteMessage = deleteMessage;
        this.deleteHistory = deleteHistory;
        this.reportSpam = reportSpam;
        this.msgId = msgId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BlockFromReplies.super.identifier();
    }

    private int flagsInitialize() {
        return BlockFromReplies.super.flags();
    }

    private boolean deleteMessageInitialize() {
        return BlockFromReplies.super.deleteMessage();
    }

    private boolean deleteHistoryInitialize() {
        return BlockFromReplies.super.deleteHistory();
    }

    private boolean reportSpamInitialize() {
        return BlockFromReplies.super.reportSpam();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean deleteMessage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleteMessage() : this.deleteMessage;
    }

    @Override
    public boolean deleteHistory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleteHistory() : this.deleteHistory;
    }

    @Override
    public boolean reportSpam() {
        InitShim shim = this.initShim;
        return shim != null ? shim.reportSpam() : this.reportSpam;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    public final ImmutableBlockFromReplies withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBlockFromReplies(value, this.flags, this.deleteMessage, this.deleteHistory, this.reportSpam, this.msgId);
    }

    public final ImmutableBlockFromReplies withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBlockFromReplies(this.identifier, value, this.deleteMessage, this.deleteHistory, this.reportSpam, this.msgId);
    }

    public final ImmutableBlockFromReplies withDeleteMessage(boolean value) {
        if (this.deleteMessage == value) {
            return this;
        }
        return new ImmutableBlockFromReplies(this.identifier, this.flags, value, this.deleteHistory, this.reportSpam, this.msgId);
    }

    public final ImmutableBlockFromReplies withDeleteHistory(boolean value) {
        if (this.deleteHistory == value) {
            return this;
        }
        return new ImmutableBlockFromReplies(this.identifier, this.flags, this.deleteMessage, value, this.reportSpam, this.msgId);
    }

    public final ImmutableBlockFromReplies withReportSpam(boolean value) {
        if (this.reportSpam == value) {
            return this;
        }
        return new ImmutableBlockFromReplies(this.identifier, this.flags, this.deleteMessage, this.deleteHistory, value, this.msgId);
    }

    public final ImmutableBlockFromReplies withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableBlockFromReplies(this.identifier, this.flags, this.deleteMessage, this.deleteHistory, this.reportSpam, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlockFromReplies && this.equalTo(0, (ImmutableBlockFromReplies)another);
    }

    private boolean equalTo(int synthetic, ImmutableBlockFromReplies another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.deleteMessage == another.deleteMessage && this.deleteHistory == another.deleteHistory && this.reportSpam == another.reportSpam && this.msgId == another.msgId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.deleteMessage);
        h += (h << 5) + Boolean.hashCode(this.deleteHistory);
        h += (h << 5) + Boolean.hashCode(this.reportSpam);
        h += (h << 5) + this.msgId;
        return h;
    }

    public String toString() {
        return "BlockFromReplies{identifier=" + this.identifier + ", flags=" + this.flags + ", deleteMessage=" + this.deleteMessage + ", deleteHistory=" + this.deleteHistory + ", reportSpam=" + this.reportSpam + ", msgId=" + this.msgId + "}";
    }

    public static ImmutableBlockFromReplies of(int msgId) {
        return new ImmutableBlockFromReplies(msgId);
    }

    public static ImmutableBlockFromReplies copyOf(BlockFromReplies instance) {
        if (instance instanceof ImmutableBlockFromReplies) {
            return (ImmutableBlockFromReplies)instance;
        }
        return ImmutableBlockFromReplies.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_DELETE_MESSAGE = 4L;
        private static final long OPT_BIT_DELETE_HISTORY = 8L;
        private static final long OPT_BIT_REPORT_SPAM = 16L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean deleteMessage;
        private boolean deleteHistory;
        private boolean reportSpam;
        private int msgId;

        private Builder() {
        }

        public final Builder from(BlockFromReplies instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BlockFromReplies instance;
            long bits = 0L;
            if (object instanceof BlockFromReplies) {
                instance = (BlockFromReplies)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.deleteHistory(instance.deleteHistory());
                this.deleteMessage(instance.deleteMessage());
                this.reportSpam(instance.reportSpam());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder deleteMessage(boolean deleteMessage) {
            this.deleteMessage = deleteMessage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder deleteHistory(boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
            this.optBits |= 8L;
            return this;
        }

        public final Builder reportSpam(boolean reportSpam) {
            this.reportSpam = reportSpam;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBlockFromReplies build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlockFromReplies(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean deleteMessageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean deleteHistoryIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean reportSpamIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            return "Cannot build BlockFromReplies, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte deleteMessageBuildStage = 0;
        private boolean deleteMessage;
        private byte deleteHistoryBuildStage = 0;
        private boolean deleteHistory;
        private byte reportSpamBuildStage = 0;
        private boolean reportSpam;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBlockFromReplies.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBlockFromReplies.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean deleteMessage() {
            if (this.deleteMessageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deleteMessageBuildStage == 0) {
                this.deleteMessageBuildStage = (byte)-1;
                this.deleteMessage = ImmutableBlockFromReplies.this.deleteMessageInitialize();
                this.deleteMessageBuildStage = 1;
            }
            return this.deleteMessage;
        }

        void deleteMessage(boolean deleteMessage) {
            this.deleteMessage = deleteMessage;
            this.deleteMessageBuildStage = 1;
        }

        boolean deleteHistory() {
            if (this.deleteHistoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deleteHistoryBuildStage == 0) {
                this.deleteHistoryBuildStage = (byte)-1;
                this.deleteHistory = ImmutableBlockFromReplies.this.deleteHistoryInitialize();
                this.deleteHistoryBuildStage = 1;
            }
            return this.deleteHistory;
        }

        void deleteHistory(boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
            this.deleteHistoryBuildStage = 1;
        }

        boolean reportSpam() {
            if (this.reportSpamBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.reportSpamBuildStage == 0) {
                this.reportSpamBuildStage = (byte)-1;
                this.reportSpam = ImmutableBlockFromReplies.this.reportSpamInitialize();
                this.reportSpamBuildStage = 1;
            }
            return this.reportSpam;
        }

        void reportSpam(boolean reportSpam) {
            this.reportSpam = reportSpam;
            this.reportSpamBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.deleteMessageBuildStage == -1) {
                attributes.add("deleteMessage");
            }
            if (this.deleteHistoryBuildStage == -1) {
                attributes.add("deleteHistory");
            }
            if (this.reportSpamBuildStage == -1) {
                attributes.add("reportSpam");
            }
            return "Cannot build BlockFromReplies, attribute initializers form cycle " + attributes;
        }
    }
}

