/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.DeleteByPhones;

public final class ImmutableDeleteByPhones
implements DeleteByPhones {
    private final int identifier;
    private final List<String> phones;

    private ImmutableDeleteByPhones(Builder builder) {
        this.phones = ImmutableDeleteByPhones.createUnmodifiableList(true, builder.phones);
        this.identifier = builder.identifierIsSet() ? builder.identifier : DeleteByPhones.super.identifier();
    }

    private ImmutableDeleteByPhones(int identifier, List<String> phones) {
        this.identifier = identifier;
        this.phones = phones;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<String> phones() {
        return this.phones;
    }

    public final ImmutableDeleteByPhones withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteByPhones(value, this.phones);
    }

    public final ImmutableDeleteByPhones withPhones(String ... elements) {
        List<String> newValue = ImmutableDeleteByPhones.createUnmodifiableList(false, ImmutableDeleteByPhones.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDeleteByPhones(this.identifier, newValue);
    }

    public final ImmutableDeleteByPhones withPhones(Iterable<String> elements) {
        if (this.phones == elements) {
            return this;
        }
        List<String> newValue = ImmutableDeleteByPhones.createUnmodifiableList(false, ImmutableDeleteByPhones.createSafeList(elements, true, false));
        return new ImmutableDeleteByPhones(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteByPhones && this.equalTo(0, (ImmutableDeleteByPhones)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteByPhones another) {
        return this.identifier == another.identifier && this.phones.equals(another.phones);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phones.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteByPhones{identifier=" + this.identifier + ", phones=" + this.phones + "}";
    }

    public static ImmutableDeleteByPhones copyOf(DeleteByPhones instance) {
        if (instance instanceof ImmutableDeleteByPhones) {
            return (ImmutableDeleteByPhones)instance;
        }
        return ImmutableDeleteByPhones.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<String> phones = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeleteByPhones instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DeleteByPhones) {
                instance = (DeleteByPhones)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllPhones(instance.phones());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addPhone(String element) {
            this.phones.add(Objects.requireNonNull(element, "phones element"));
            return this;
        }

        public final Builder addPhones(String ... elements) {
            for (String element : elements) {
                this.phones.add(Objects.requireNonNull(element, "phones element"));
            }
            return this;
        }

        public final Builder phones(Iterable<String> elements) {
            this.phones.clear();
            return this.addAllPhones(elements);
        }

        public final Builder addAllPhones(Iterable<String> elements) {
            for (String element : elements) {
                this.phones.add(Objects.requireNonNull(element, "phones element"));
            }
            return this;
        }

        public ImmutableDeleteByPhones build() {
            return new ImmutableDeleteByPhones(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

