/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.DeleteContacts;

public final class ImmutableDeleteContacts
implements DeleteContacts {
    private final int identifier;
    private final List<InputUser> id;

    private ImmutableDeleteContacts(Builder builder) {
        this.id = ImmutableDeleteContacts.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : DeleteContacts.super.identifier();
    }

    private ImmutableDeleteContacts(int identifier, List<InputUser> id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputUser> id() {
        return this.id;
    }

    public final ImmutableDeleteContacts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteContacts(value, this.id);
    }

    public final ImmutableDeleteContacts withId(InputUser ... elements) {
        List<InputUser> newValue = ImmutableDeleteContacts.createUnmodifiableList(false, ImmutableDeleteContacts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDeleteContacts(this.identifier, newValue);
    }

    public final ImmutableDeleteContacts withId(Iterable<? extends InputUser> elements) {
        if (this.id == elements) {
            return this;
        }
        List<InputUser> newValue = ImmutableDeleteContacts.createUnmodifiableList(false, ImmutableDeleteContacts.createSafeList(elements, true, false));
        return new ImmutableDeleteContacts(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteContacts && this.equalTo(0, (ImmutableDeleteContacts)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteContacts another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteContacts{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableDeleteContacts copyOf(DeleteContacts instance) {
        if (instance instanceof ImmutableDeleteContacts) {
            return (ImmutableDeleteContacts)instance;
        }
        return ImmutableDeleteContacts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputUser> id = new ArrayList<InputUser>();

        private Builder() {
        }

        public final Builder from(DeleteContacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DeleteContacts instance;
            long bits = 0L;
            if (object instanceof DeleteContacts) {
                instance = (DeleteContacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllId(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addId(InputUser element) {
            this.id.add(Objects.requireNonNull(element, "id element"));
            return this;
        }

        public final Builder addId(InputUser ... elements) {
            for (InputUser element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public final Builder id(Iterable<? extends InputUser> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<? extends InputUser> elements) {
            for (InputUser inputUser : elements) {
                this.id.add(Objects.requireNonNull(inputUser, "id element"));
            }
            return this;
        }

        public ImmutableDeleteContacts build() {
            return new ImmutableDeleteContacts(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

