/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.GetBlocked;

public final class ImmutableGetBlocked
implements GetBlocked {
    private final int identifier;
    private final int offset;
    private final int limit;

    private ImmutableGetBlocked(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.identifier = GetBlocked.super.identifier();
    }

    private ImmutableGetBlocked(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetBlocked.super.identifier();
    }

    private ImmutableGetBlocked(int identifier, int offset, int limit) {
        this.identifier = identifier;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetBlocked withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetBlocked(value, this.offset, this.limit);
    }

    public final ImmutableGetBlocked withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetBlocked(this.identifier, value, this.limit);
    }

    public final ImmutableGetBlocked withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetBlocked(this.identifier, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetBlocked && this.equalTo(0, (ImmutableGetBlocked)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetBlocked another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetBlocked{identifier=" + this.identifier + ", offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetBlocked of(int offset, int limit) {
        return new ImmutableGetBlocked(offset, limit);
    }

    public static ImmutableGetBlocked copyOf(GetBlocked instance) {
        if (instance instanceof ImmutableGetBlocked) {
            return (ImmutableGetBlocked)instance;
        }
        return ImmutableGetBlocked.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetBlocked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetBlocked instance;
            long bits = 0L;
            if (object instanceof GetBlocked) {
                instance = (GetBlocked)object;
                this.offset(instance.offset());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetBlocked build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetBlocked(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetBlocked, some of required attributes are not set " + attributes;
        }
    }
}

