/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.GetLocated;

public final class ImmutableGetLocated
implements GetLocated {
    private final int identifier;
    private final int flags;
    private final boolean background;
    private final InputGeoPoint geoPoint;
    @Nullable
    private final Integer selfExpires;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetLocated(InputGeoPoint geoPoint) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.selfExpires = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.background = this.initShim.background();
        this.initShim = null;
    }

    private ImmutableGetLocated(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.selfExpires = builder.selfExpires;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.backgroundIsSet()) {
            this.initShim.background(builder.background);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.background = this.initShim.background();
        this.initShim = null;
    }

    private ImmutableGetLocated(int identifier, int flags, boolean background, InputGeoPoint geoPoint, @Nullable Integer selfExpires) {
        this.identifier = identifier;
        this.flags = flags;
        this.background = background;
        this.geoPoint = geoPoint;
        this.selfExpires = selfExpires;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetLocated.super.identifier();
    }

    private int flagsInitialize() {
        return GetLocated.super.flags();
    }

    private boolean backgroundInitialize() {
        return GetLocated.super.background();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean background() {
        InitShim shim = this.initShim;
        return shim != null ? shim.background() : this.background;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    @Nullable
    public Integer selfExpires() {
        return this.selfExpires;
    }

    public final ImmutableGetLocated withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetLocated(value, this.flags, this.background, this.geoPoint, this.selfExpires);
    }

    public final ImmutableGetLocated withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetLocated(this.identifier, value, this.background, this.geoPoint, this.selfExpires);
    }

    public final ImmutableGetLocated withBackground(boolean value) {
        if (this.background == value) {
            return this;
        }
        return new ImmutableGetLocated(this.identifier, this.flags, value, this.geoPoint, this.selfExpires);
    }

    public final ImmutableGetLocated withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableGetLocated(this.identifier, this.flags, this.background, newValue, this.selfExpires);
    }

    public final ImmutableGetLocated withSelfExpires(@Nullable Integer value) {
        if (Objects.equals(this.selfExpires, value)) {
            return this;
        }
        return new ImmutableGetLocated(this.identifier, this.flags, this.background, this.geoPoint, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetLocated && this.equalTo(0, (ImmutableGetLocated)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetLocated another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.background == another.background && this.geoPoint.equals(another.geoPoint) && Objects.equals(this.selfExpires, another.selfExpires);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.background);
        h += (h << 5) + this.geoPoint.hashCode();
        h += (h << 5) + Objects.hashCode(this.selfExpires);
        return h;
    }

    public String toString() {
        return "GetLocated{identifier=" + this.identifier + ", flags=" + this.flags + ", background=" + this.background + ", geoPoint=" + this.geoPoint + ", selfExpires=" + this.selfExpires + "}";
    }

    public static ImmutableGetLocated of(InputGeoPoint geoPoint) {
        return new ImmutableGetLocated(geoPoint);
    }

    public static ImmutableGetLocated copyOf(GetLocated instance) {
        if (instance instanceof ImmutableGetLocated) {
            return (ImmutableGetLocated)instance;
        }
        return ImmutableGetLocated.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BACKGROUND = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean background;
        private InputGeoPoint geoPoint;
        private Integer selfExpires;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetLocated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetLocated) {
                Integer selfExpiresValue;
                instance = (GetLocated)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((selfExpiresValue = instance.selfExpires()) != null) {
                    this.selfExpires(selfExpiresValue);
                }
                this.geoPoint(instance.geoPoint());
                this.background(instance.background());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder background(boolean background) {
            this.background = background;
            this.optBits |= 4L;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder selfExpires(@Nullable Integer selfExpires) {
            this.selfExpires = selfExpires;
            return this;
        }

        public ImmutableGetLocated build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetLocated(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean backgroundIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            return "Cannot build GetLocated, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte backgroundBuildStage = 0;
        private boolean background;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetLocated.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetLocated.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean background() {
            if (this.backgroundBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backgroundBuildStage == 0) {
                this.backgroundBuildStage = (byte)-1;
                this.background = ImmutableGetLocated.this.backgroundInitialize();
                this.backgroundBuildStage = 1;
            }
            return this.background;
        }

        void background(boolean background) {
            this.background = background;
            this.backgroundBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.backgroundBuildStage == -1) {
                attributes.add("background");
            }
            return "Cannot build GetLocated, attribute initializers form cycle " + attributes;
        }
    }
}

