/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.GetTopPeers;

public final class ImmutableGetTopPeers
implements GetTopPeers {
    private final int identifier;
    private final int flags;
    private final boolean correspondents;
    private final boolean botsPm;
    private final boolean botsInline;
    private final boolean phoneCalls;
    private final boolean forwardUsers;
    private final boolean forwardChats;
    private final boolean groups;
    private final boolean channels;
    private final int offset;
    private final int limit;
    private final long hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetTopPeers(int offset, int limit, long hash) {
        this.offset = offset;
        this.limit = limit;
        this.hash = hash;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.correspondents = this.initShim.correspondents();
        this.botsPm = this.initShim.botsPm();
        this.botsInline = this.initShim.botsInline();
        this.phoneCalls = this.initShim.phoneCalls();
        this.forwardUsers = this.initShim.forwardUsers();
        this.forwardChats = this.initShim.forwardChats();
        this.groups = this.initShim.groups();
        this.channels = this.initShim.channels();
        this.initShim = null;
    }

    private ImmutableGetTopPeers(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.hash = builder.hash;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.correspondentsIsSet()) {
            this.initShim.correspondents(builder.correspondents);
        }
        if (builder.botsPmIsSet()) {
            this.initShim.botsPm(builder.botsPm);
        }
        if (builder.botsInlineIsSet()) {
            this.initShim.botsInline(builder.botsInline);
        }
        if (builder.phoneCallsIsSet()) {
            this.initShim.phoneCalls(builder.phoneCalls);
        }
        if (builder.forwardUsersIsSet()) {
            this.initShim.forwardUsers(builder.forwardUsers);
        }
        if (builder.forwardChatsIsSet()) {
            this.initShim.forwardChats(builder.forwardChats);
        }
        if (builder.groupsIsSet()) {
            this.initShim.groups(builder.groups);
        }
        if (builder.channelsIsSet()) {
            this.initShim.channels(builder.channels);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.correspondents = this.initShim.correspondents();
        this.botsPm = this.initShim.botsPm();
        this.botsInline = this.initShim.botsInline();
        this.phoneCalls = this.initShim.phoneCalls();
        this.forwardUsers = this.initShim.forwardUsers();
        this.forwardChats = this.initShim.forwardChats();
        this.groups = this.initShim.groups();
        this.channels = this.initShim.channels();
        this.initShim = null;
    }

    private ImmutableGetTopPeers(int identifier, int flags, boolean correspondents, boolean botsPm, boolean botsInline, boolean phoneCalls, boolean forwardUsers, boolean forwardChats, boolean groups, boolean channels, int offset, int limit, long hash) {
        this.identifier = identifier;
        this.flags = flags;
        this.correspondents = correspondents;
        this.botsPm = botsPm;
        this.botsInline = botsInline;
        this.phoneCalls = phoneCalls;
        this.forwardUsers = forwardUsers;
        this.forwardChats = forwardChats;
        this.groups = groups;
        this.channels = channels;
        this.offset = offset;
        this.limit = limit;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetTopPeers.super.identifier();
    }

    private int flagsInitialize() {
        return GetTopPeers.super.flags();
    }

    private boolean correspondentsInitialize() {
        return GetTopPeers.super.correspondents();
    }

    private boolean botsPmInitialize() {
        return GetTopPeers.super.botsPm();
    }

    private boolean botsInlineInitialize() {
        return GetTopPeers.super.botsInline();
    }

    private boolean phoneCallsInitialize() {
        return GetTopPeers.super.phoneCalls();
    }

    private boolean forwardUsersInitialize() {
        return GetTopPeers.super.forwardUsers();
    }

    private boolean forwardChatsInitialize() {
        return GetTopPeers.super.forwardChats();
    }

    private boolean groupsInitialize() {
        return GetTopPeers.super.groups();
    }

    private boolean channelsInitialize() {
        return GetTopPeers.super.channels();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean correspondents() {
        InitShim shim = this.initShim;
        return shim != null ? shim.correspondents() : this.correspondents;
    }

    @Override
    public boolean botsPm() {
        InitShim shim = this.initShim;
        return shim != null ? shim.botsPm() : this.botsPm;
    }

    @Override
    public boolean botsInline() {
        InitShim shim = this.initShim;
        return shim != null ? shim.botsInline() : this.botsInline;
    }

    @Override
    public boolean phoneCalls() {
        InitShim shim = this.initShim;
        return shim != null ? shim.phoneCalls() : this.phoneCalls;
    }

    @Override
    public boolean forwardUsers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forwardUsers() : this.forwardUsers;
    }

    @Override
    public boolean forwardChats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forwardChats() : this.forwardChats;
    }

    @Override
    public boolean groups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.groups() : this.groups;
    }

    @Override
    public boolean channels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.channels() : this.channels;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetTopPeers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetTopPeers(value, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, value, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withCorrespondents(boolean value) {
        if (this.correspondents == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, value, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withBotsPm(boolean value) {
        if (this.botsPm == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, value, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withBotsInline(boolean value) {
        if (this.botsInline == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, value, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withPhoneCalls(boolean value) {
        if (this.phoneCalls == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, value, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withForwardUsers(boolean value) {
        if (this.forwardUsers == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, value, this.forwardChats, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withForwardChats(boolean value) {
        if (this.forwardChats == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, value, this.groups, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withGroups(boolean value) {
        if (this.groups == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, value, this.channels, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withChannels(boolean value) {
        if (this.channels == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, value, this.offset, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, value, this.limit, this.hash);
    }

    public final ImmutableGetTopPeers withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, value, this.hash);
    }

    public final ImmutableGetTopPeers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetTopPeers(this.identifier, this.flags, this.correspondents, this.botsPm, this.botsInline, this.phoneCalls, this.forwardUsers, this.forwardChats, this.groups, this.channels, this.offset, this.limit, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetTopPeers && this.equalTo(0, (ImmutableGetTopPeers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetTopPeers another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.correspondents == another.correspondents && this.botsPm == another.botsPm && this.botsInline == another.botsInline && this.phoneCalls == another.phoneCalls && this.forwardUsers == another.forwardUsers && this.forwardChats == another.forwardChats && this.groups == another.groups && this.channels == another.channels && this.offset == another.offset && this.limit == another.limit && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.correspondents);
        h += (h << 5) + Boolean.hashCode(this.botsPm);
        h += (h << 5) + Boolean.hashCode(this.botsInline);
        h += (h << 5) + Boolean.hashCode(this.phoneCalls);
        h += (h << 5) + Boolean.hashCode(this.forwardUsers);
        h += (h << 5) + Boolean.hashCode(this.forwardChats);
        h += (h << 5) + Boolean.hashCode(this.groups);
        h += (h << 5) + Boolean.hashCode(this.channels);
        h += (h << 5) + this.offset;
        h += (h << 5) + this.limit;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetTopPeers{identifier=" + this.identifier + ", flags=" + this.flags + ", correspondents=" + this.correspondents + ", botsPm=" + this.botsPm + ", botsInline=" + this.botsInline + ", phoneCalls=" + this.phoneCalls + ", forwardUsers=" + this.forwardUsers + ", forwardChats=" + this.forwardChats + ", groups=" + this.groups + ", channels=" + this.channels + ", offset=" + this.offset + ", limit=" + this.limit + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetTopPeers of(int offset, int limit, long hash) {
        return new ImmutableGetTopPeers(offset, limit, hash);
    }

    public static ImmutableGetTopPeers copyOf(GetTopPeers instance) {
        if (instance instanceof ImmutableGetTopPeers) {
            return (ImmutableGetTopPeers)instance;
        }
        return ImmutableGetTopPeers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CORRESPONDENTS = 4L;
        private static final long OPT_BIT_BOTS_PM = 8L;
        private static final long OPT_BIT_BOTS_INLINE = 16L;
        private static final long OPT_BIT_PHONE_CALLS = 32L;
        private static final long OPT_BIT_FORWARD_USERS = 64L;
        private static final long OPT_BIT_FORWARD_CHATS = 128L;
        private static final long OPT_BIT_GROUPS = 256L;
        private static final long OPT_BIT_CHANNELS = 512L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean correspondents;
        private boolean botsPm;
        private boolean botsInline;
        private boolean phoneCalls;
        private boolean forwardUsers;
        private boolean forwardChats;
        private boolean groups;
        private boolean channels;
        private int offset;
        private int limit;
        private long hash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetTopPeers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetTopPeers) {
                instance = (GetTopPeers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.botsPm(instance.botsPm());
                this.offset(instance.offset());
                this.forwardChats(instance.forwardChats());
                this.flags(instance.flags());
                this.groups(instance.groups());
                this.correspondents(instance.correspondents());
                this.phoneCalls(instance.phoneCalls());
                this.channels(instance.channels());
                this.botsInline(instance.botsInline());
                this.forwardUsers(instance.forwardUsers());
                this.limit(instance.limit());
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder correspondents(boolean correspondents) {
            this.correspondents = correspondents;
            this.optBits |= 4L;
            return this;
        }

        public final Builder botsPm(boolean botsPm) {
            this.botsPm = botsPm;
            this.optBits |= 8L;
            return this;
        }

        public final Builder botsInline(boolean botsInline) {
            this.botsInline = botsInline;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder phoneCalls(boolean phoneCalls) {
            this.phoneCalls = phoneCalls;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder forwardUsers(boolean forwardUsers) {
            this.forwardUsers = forwardUsers;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder forwardChats(boolean forwardChats) {
            this.forwardChats = forwardChats;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder groups(boolean groups) {
            this.groups = groups;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder channels(boolean channels) {
            this.channels = channels;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetTopPeers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetTopPeers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean correspondentsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean botsPmIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean botsInlineIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean phoneCallsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean forwardUsersIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean forwardChatsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean groupsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean channelsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetTopPeers, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte correspondentsBuildStage = 0;
        private boolean correspondents;
        private byte botsPmBuildStage = 0;
        private boolean botsPm;
        private byte botsInlineBuildStage = 0;
        private boolean botsInline;
        private byte phoneCallsBuildStage = 0;
        private boolean phoneCalls;
        private byte forwardUsersBuildStage = 0;
        private boolean forwardUsers;
        private byte forwardChatsBuildStage = 0;
        private boolean forwardChats;
        private byte groupsBuildStage = 0;
        private boolean groups;
        private byte channelsBuildStage = 0;
        private boolean channels;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetTopPeers.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetTopPeers.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean correspondents() {
            if (this.correspondentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.correspondentsBuildStage == 0) {
                this.correspondentsBuildStage = (byte)-1;
                this.correspondents = ImmutableGetTopPeers.this.correspondentsInitialize();
                this.correspondentsBuildStage = 1;
            }
            return this.correspondents;
        }

        void correspondents(boolean correspondents) {
            this.correspondents = correspondents;
            this.correspondentsBuildStage = 1;
        }

        boolean botsPm() {
            if (this.botsPmBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botsPmBuildStage == 0) {
                this.botsPmBuildStage = (byte)-1;
                this.botsPm = ImmutableGetTopPeers.this.botsPmInitialize();
                this.botsPmBuildStage = 1;
            }
            return this.botsPm;
        }

        void botsPm(boolean botsPm) {
            this.botsPm = botsPm;
            this.botsPmBuildStage = 1;
        }

        boolean botsInline() {
            if (this.botsInlineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botsInlineBuildStage == 0) {
                this.botsInlineBuildStage = (byte)-1;
                this.botsInline = ImmutableGetTopPeers.this.botsInlineInitialize();
                this.botsInlineBuildStage = 1;
            }
            return this.botsInline;
        }

        void botsInline(boolean botsInline) {
            this.botsInline = botsInline;
            this.botsInlineBuildStage = 1;
        }

        boolean phoneCalls() {
            if (this.phoneCallsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.phoneCallsBuildStage == 0) {
                this.phoneCallsBuildStage = (byte)-1;
                this.phoneCalls = ImmutableGetTopPeers.this.phoneCallsInitialize();
                this.phoneCallsBuildStage = 1;
            }
            return this.phoneCalls;
        }

        void phoneCalls(boolean phoneCalls) {
            this.phoneCalls = phoneCalls;
            this.phoneCallsBuildStage = 1;
        }

        boolean forwardUsers() {
            if (this.forwardUsersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forwardUsersBuildStage == 0) {
                this.forwardUsersBuildStage = (byte)-1;
                this.forwardUsers = ImmutableGetTopPeers.this.forwardUsersInitialize();
                this.forwardUsersBuildStage = 1;
            }
            return this.forwardUsers;
        }

        void forwardUsers(boolean forwardUsers) {
            this.forwardUsers = forwardUsers;
            this.forwardUsersBuildStage = 1;
        }

        boolean forwardChats() {
            if (this.forwardChatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forwardChatsBuildStage == 0) {
                this.forwardChatsBuildStage = (byte)-1;
                this.forwardChats = ImmutableGetTopPeers.this.forwardChatsInitialize();
                this.forwardChatsBuildStage = 1;
            }
            return this.forwardChats;
        }

        void forwardChats(boolean forwardChats) {
            this.forwardChats = forwardChats;
            this.forwardChatsBuildStage = 1;
        }

        boolean groups() {
            if (this.groupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupsBuildStage == 0) {
                this.groupsBuildStage = (byte)-1;
                this.groups = ImmutableGetTopPeers.this.groupsInitialize();
                this.groupsBuildStage = 1;
            }
            return this.groups;
        }

        void groups(boolean groups) {
            this.groups = groups;
            this.groupsBuildStage = 1;
        }

        boolean channels() {
            if (this.channelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.channelsBuildStage == 0) {
                this.channelsBuildStage = (byte)-1;
                this.channels = ImmutableGetTopPeers.this.channelsInitialize();
                this.channelsBuildStage = 1;
            }
            return this.channels;
        }

        void channels(boolean channels) {
            this.channels = channels;
            this.channelsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.correspondentsBuildStage == -1) {
                attributes.add("correspondents");
            }
            if (this.botsPmBuildStage == -1) {
                attributes.add("botsPm");
            }
            if (this.botsInlineBuildStage == -1) {
                attributes.add("botsInline");
            }
            if (this.phoneCallsBuildStage == -1) {
                attributes.add("phoneCalls");
            }
            if (this.forwardUsersBuildStage == -1) {
                attributes.add("forwardUsers");
            }
            if (this.forwardChatsBuildStage == -1) {
                attributes.add("forwardChats");
            }
            if (this.groupsBuildStage == -1) {
                attributes.add("groups");
            }
            if (this.channelsBuildStage == -1) {
                attributes.add("channels");
            }
            return "Cannot build GetTopPeers, attribute initializers form cycle " + attributes;
        }
    }
}

