/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputContact;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.ImportContacts;

public final class ImmutableImportContacts
implements ImportContacts {
    private final int identifier;
    private final List<InputContact> contacts;

    private ImmutableImportContacts(Builder builder) {
        this.contacts = ImmutableImportContacts.createUnmodifiableList(true, builder.contacts);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ImportContacts.super.identifier();
    }

    private ImmutableImportContacts(int identifier, List<InputContact> contacts) {
        this.identifier = identifier;
        this.contacts = contacts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputContact> contacts() {
        return this.contacts;
    }

    public final ImmutableImportContacts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableImportContacts(value, this.contacts);
    }

    public final ImmutableImportContacts withContacts(InputContact ... elements) {
        List<InputContact> newValue = ImmutableImportContacts.createUnmodifiableList(false, ImmutableImportContacts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImportContacts(this.identifier, newValue);
    }

    public final ImmutableImportContacts withContacts(Iterable<? extends InputContact> elements) {
        if (this.contacts == elements) {
            return this;
        }
        List<InputContact> newValue = ImmutableImportContacts.createUnmodifiableList(false, ImmutableImportContacts.createSafeList(elements, true, false));
        return new ImmutableImportContacts(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportContacts && this.equalTo(0, (ImmutableImportContacts)another);
    }

    private boolean equalTo(int synthetic, ImmutableImportContacts another) {
        return this.identifier == another.identifier && this.contacts.equals(another.contacts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.contacts.hashCode();
        return h;
    }

    public String toString() {
        return "ImportContacts{identifier=" + this.identifier + ", contacts=" + this.contacts + "}";
    }

    public static ImmutableImportContacts copyOf(ImportContacts instance) {
        if (instance instanceof ImmutableImportContacts) {
            return (ImmutableImportContacts)instance;
        }
        return ImmutableImportContacts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputContact> contacts = new ArrayList<InputContact>();

        private Builder() {
        }

        public final Builder from(ImportContacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ImportContacts instance;
            long bits = 0L;
            if (object instanceof ImportContacts) {
                instance = (ImportContacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllContacts(instance.contacts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addContact(InputContact element) {
            this.contacts.add(Objects.requireNonNull(element, "contacts element"));
            return this;
        }

        public final Builder addContacts(InputContact ... elements) {
            for (InputContact element : elements) {
                this.contacts.add(Objects.requireNonNull(element, "contacts element"));
            }
            return this;
        }

        public final Builder contacts(Iterable<? extends InputContact> elements) {
            this.contacts.clear();
            return this.addAllContacts(elements);
        }

        public final Builder addAllContacts(Iterable<? extends InputContact> elements) {
            for (InputContact inputContact : elements) {
                this.contacts.add(Objects.requireNonNull(inputContact, "contacts element"));
            }
            return this;
        }

        public ImmutableImportContacts build() {
            return new ImmutableImportContacts(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

